;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: analyse-h -*-
#|
This code was developed in the joint research project APPLY funded by
the German Ministry of Research and Technology under the project code
ITW9102D5.

Copyright 1994-2010 Fraunhofer ISST

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent 
versions of the EUPL (the "Licence");

You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at:
http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
Unless required by applicable law or agreed to in
writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

See the Licence for the specific language governing permissions and limitations under the Licence.

-----------------------------------------------------------------------------------
TITLE: definitions for the transformation from LZS to MZS
-----------------------------------------------------------------------------------
File:    analyse-h.em
Version: 2.0 (last modification on Fri Feb 25 13:33:07 1994)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de
HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/analyse-h.em[2.0]:
  
[1.1] Fri Mar  5 13:00:40 1993 hfried@isst saved
  [Fri Mar  5 12:04:16 1993] Intention for change:
  text
  text
[1.2] Thu Mar 18 08:05:45 1993 hfried@isst saved
  text
[1.3] Thu Mar 18 08:52:23 1993 hfried@isst proposed
  
[1.4] Wed Mar 24 13:47:41 1993 hfried@isst proposed
  [Thu Mar 18 09:10:26 1993] Intention for change:
  + glob anna
[1.5] Thu Mar 25 11:18:36 1993 hfried@isst proposed
  [Wed Mar 24 14:52:30 1993] Intention for change:
  + gen-fun
  new head
[1.6] Tue Apr 13 14:08:09 1993 hfried@isst proposed
  [Thu Mar 25 11:53:38 1993] Intention for change:
  closures
[1.7] Tue Apr 20 15:45:03 1993 hfried@isst proposed
  [Tue Apr 13 14:14:48 1993] Intention for change:
  cast
[1.8] Mon Jun 21 11:32:46 1993 hfried@isst published
  [Tue Apr 20 15:53:51 1993] Intention for change:
[1.9] Wed Oct  6 16:34:02 1993 hfried@isst saved
  [Wed Oct  6 16:13:37 1993] Intention for change:
  add *analyse-method-subset*
[1.10] Tue Nov 16 11:52:33 1993 hfried@isst proposed
  [Mon Nov 15 16:07:28 1993] Intention for change:
  actual-method-subset
[1.11] Fri Nov 26 10:41:49 1993 imohr@isst proposed
  [Wed Nov 24 14:50:27 1993] Intention for change:
  removing defclass, replace it by defstandardclass
[1.12] Mon Jan 24 15:17:00 1994 hfried@isst published
  [Mon Jan 24 15:00:40 1994] Intention for change:
  add slot-value
[1.13] Mon Feb 28 14:45:50 1994 wheick@isst proposed
  [Fri Feb 25 13:28:15 1994] Intention for change:
  insert eulisp0,1
  done
[2.0] Mon Feb 28 14:45:50 1994 wheick@isst proposed
  [Fri Feb 25 13:28:15 1994] Intention for change:
  insert eulisp0,1
  done

-----------------------------------------------------------------------------------
|#

#module analyse-h

(import ((except (format) eulisp1) 
         lzs
         mzs
         accessors
         (only (assoc format) common-lisp)) 

 syntax (eulisp1
         apply-standard)

 export  (<cast>
          closure env pathes typepathes block 
          rec-calls calls tests moves
	  get-slot-value set-slot-value
          $normal $data $closure
          $funcall warning
          *started-and-not-finished-functions* *counter* l2m-a 
          append-stat  cons-block a-number finish-a
	  *actual-method-subset*)
 )

(defstandardclass <cast> () 
  (type :accessor :initarg :initform ())
  )

;--- definitions, exportations, initialization forms

;;-----------------------------------------------------------------------------------
;; global-environments
;;-----------------------------------------------------------------------------------

;       -------
(defvar closure  ())
;       -------
(defvar env       ())
;       ------
(defvar pathes ())
;       ----------
(defvar typepathes ())
;       ----------
(defvar block ())
;       -----
;;-----------------------------------------------------------------------------------
;; annotations for the function
;;-----------------------------------------------------------------------------------

;       --------
(defvar rec-calls ())
;       --------
(defvar calls    ())
;       ------
(defvar tests ())
;       -----
(defvar moves ())
;       -----
(defvar get-slot-value ())
;       --------------
(defvar set-slot-value ())
;       --------------
; function types
;            -------
(defconstant $normal 0)
;            -------
(defconstant $data   1)
;            --------
(defconstant $closure 2)
;            --------
(defconstant $funcall -99)
;            --------
;;-----------------------------------------------------------------------------------
;; local variables
;;-----------------------------------------------------------------------------------

;         ------------------------------------
(defvar *started-and-not-finished-functions* ())
;         ------------------------------------
(defvar *counter*                               1)
;         ---------

(defun a-number ()
  (let ((n (dynamic *counter*)))
    (setf (dynamic *counter*) (+ (dynamic *counter*) 1))
    n))


;;-----------------------------------------------------------------------------------
;;  generic-function
;;-----------------------------------------------------------------------------------

;           -----
(defgeneric l2m-a (context lzs-object))
;           -----

;      #######
(defun warning (string . args)
;      #######
  (apply #'format t string args))

;      ###########
(defun append-stat (list ele)
;      ###########
  (if (null list) (list ele)
      (progn (append-stat1 list (list ele))
             list)))

;      ------------
(defun append-stat1 (list ele)
;      ------------ 
  (if (null (cdr list))
    (setf (cdr list) ele)
    (append-stat1 (cdr list) ele)))

;           ########
(defgeneric finish-a (con var-or-constant))
;           ########

;      ##########
(defun cons-block (block pathes)
;      ##########
  (if pathes 
    (cons (cons block (car pathes))
          (cons-block block (cdr pathes)))
    ()))

(deflocal *actual-method-subset* ())

#module-end
