;*******************************************************************************
;
; Graphical AI Tools Environment (GATE)
; Version 2.2
;
; ** Copyright (c) 1984, 1985, 1986 by Erik T. Mueller. All Rights Reserved.
;
; This file contains:
;
; - Load GATE.
;
;*******************************************************************************

(progn
 (setq *gate-version* "GATE 2.2, Common Lisp version of 19990506")
 (format t "=======================~%")
 (format t "Loading ~A...~%" *gate-version*)
 (format t "=======================~%")
 nil)

(load "compat.cl")

(setq *gate-input* *standard-input*)
(setq *gate-output* *standard-output*)
(setq *gate-dbg* *standard-output*)
(setq *gate-warn-dbg* t)
(setq *gen-stream* nil)
(setq ob-placement nil)

(if (not (boundp '*gate-load-options*))
    (setq *gate-load-options* nil)
    nil)

(load "loop.cl")
(load "gate_utils.cl")
(load "ob_main.cl")
(load "ob_ty.cl")
(load "ob_read_pr.cl")
(load "ob_unify.cl")
(load "ob_instan.cl")
(load "ob_cx.cl")
(load "ob_prove.cl")

(interest 'ob-warn 'all)
(interest 'context 'all)

; Bug: obnames don't work in fcreate
(defun ob-test ()
 (ty$create 'PTRANS nil '(nil (actor from to obj) ()))
 (ty$create 'PERSON nil '(nil (name) ()))
 (ty$create 'LOCATION nil '(nil (name) ()))
 (setq z (ob$fcreate '(PTRANS actor (PERSON name "John"
                                     obname John)
                             from (LOCATION name "home")
                             to (LOCATION name "store")
                             obj (PERSON name "Mary"
                                     obname Mary))))
 (po z))

(format t "=======================~%")
(format t "Welcome to ~A~%" *gate-version*)
(format t "Bugs/problems/questions to erik@signiform.com~%")
(format t "=======================~%")
    
(if (member 'daydreamer *gate-load-options*)
    (load "dd_get.cl"))
