;structs.scm
;SLaTeX v. 2.3
;Structures used by SLaTeX
;(c) Dorai Sitaram, Rice U., 1991, 1994

(module SLaTeX.)

(local *max-line-length* &void-space &plain-space
  &init-space &init-plain-space &paren-space &bracket-space
  &quote-space &inner-space &void-tab &set-tab &move-tab
  &tabbed-crg-ret &plain-crg-ret &void-notab &begin-comment
  &mid-comment &begin-string &mid-string &end-string &begin-math
  &mid-math &end-math make-raw-line =rtedge =char =space
  =tab =notab make-line *line1* *line2* make-case-frame
  =in-case-tkn =in-bktd-ctag-exp =in-case-exp make-bq-frame
  =in-comma =in-bq-tkn =in-bktd-bq-exp *latex-paragraph-mode?*
  *intext?* *code-env-spec* *in* *out* *in-qtd-tkn*
  *in-bktd-qtd-exp* *in-mac-tkn* *in-bktd-mac-exp* *case-stack*
  *bq-stack* display-space display-tab display-notab)

(define *max-line-length* 200)

(defenum
  ;possible values of =space
  &void-space
  &plain-space
  &init-space
  &init-plain-space
  &paren-space
  &bracket-space
  &quote-space
  &inner-space)

(defenum
  ;possible values of =tab
  &void-tab
  &set-tab
  &move-tab
  &tabbed-crg-ret
  &plain-crg-ret)

(defenum
  ;possible values of =notab
  &void-notab
  &begin-comment
  &mid-comment
  &begin-string
  &mid-string
  &end-string
  &begin-math
  &mid-math
  &end-math)

(defrecord make-raw-line
  =rtedge =char =space =tab =notab)

(define make-line
  (lambda ()
    ;makes a "line" record
    (let ((l (make-raw-line)))
      (setf (of l =rtedge) 0)
      (setf (of l =char) (make-string *max-line-length* #\space))
      (setf (of l =space) (make-string *max-line-length* &void-space))
      (setf (of l =tab) (make-string *max-line-length* &void-tab))
      (setf (of l =notab) (make-string *max-line-length* &void-notab))
      l)))

(define *line1* (make-line))
(define *line2* (make-line))

(defrecord make-case-frame
  =in-ctag-tkn =in-bktd-ctag-exp =in-case-exp)

(defrecord make-bq-frame
  =in-comma =in-bq-tkn =in-bktd-bq-exp)

(define *latex-paragraph-mode?* 'fwd1)

(define *intext?* 'fwd2)
(define *code-env-spec* "UNDEFINED")

(define *in* 'fwd3)
(define *out* 'fwd4)

(define *in-qtd-tkn* 'fwd5)
(define *in-bktd-qtd-exp* 'fwd6)

(define *in-mac-tkn* 'fwd7)
(define *in-bktd-mac-exp* 'fwd8)

(define *case-stack* 'fwd9)

(define *bq-stack* 'fwd10)

(define display-space
  (lambda (s p)
    (cond ((eq? s &plain-space) (display #\space p))
	  ((eq? s &init-plain-space) (display #\space p))
	  ((eq? s &init-space) (display "\\HL " p))
	  ((eq? s &paren-space) (display "\\PRN " p))
	  ((eq? s &bracket-space) (display "\\BKT " p))
	  ((eq? s &quote-space) (display "\\QUO " p))
	  ((eq? s &inner-space) (display "\\ " p)))))

(define display-tab
  (lambda (tab p)
    (cond ((eq? tab &set-tab) (display "\\=" p))
	  ((eq? tab &move-tab) (display "\\>" p)))))

(define display-notab
  (lambda (notab p)
    (cond ((eq? notab &begin-string) (display "\\dt{" p))
	  ((eq? notab &end-string) (display "}" p)))))
