;slaconfg.scm
;Configures SLaTeX for your Scheme
;(c) Dorai Sitaram, Rice U., 1991, 1994

(define *dialect* 'forward)
(define *op-sys* 'forward)

(call-with-input-file "config.dat"
  (lambda (p)
    (set! *dialect* (read p))
    (set! *op-sys* (read p))))

(if (not (memq *dialect*
	  '(chez cscheme elk pcsge schemetoc scm
		umbscheme other)))
    (set! *dialect* 'other))

(if (not (memq *op-sys* '(dos unix)))
    ;if it isn't dos, assume it's unix-like
    (set! *op-sys* 'unix))

(if (eq? *dialect* 'elk)
    (define force-output flush-output-port))
(if (eq? *dialect* 'chez)
    (define force-output flush-output))
(if (not (memq *dialect* '(chez cl elk scm)))
    (define force-output (lambda z 'assume-output-forced)))

(load "preproc.scm")

(define list-of-slatex-files
  (list
    "s4.scm"
    "seqprocs.scm"
    "fileproc.scm"
    "lerror.scm"
    "defaults.scm"
    "helpers.scm"
    "structs.scm"
    "peephole.scm"
    "codeset.scm"
    "pathproc.scm"
    "texread.scm"
    "proctex.scm"
    "proctex2.scm"))

(define generate-compatible-file
  (lambda (output-file)
    (cond ((memq *dialect* '(chez cscheme scm))
	   (if (file-exists? output-file)
	       (delete-file output-file) 'ok))
	  (else
            (newline)
	    (display "If configuring fails following this sentence, ")
            (newline)
            (display "you most likely already have a slatex.scm in the ")
            (display "current directory.")
            (newline)
            (display "Delete it and retry.")
            (newline)))

    (call-with-output-file output-file
      (lambda (outp)

	;begin banner
        (newline outp)
	(display ";slatex.scm file generated using config.scm" outp)
        (newline outp)
        (display ";This file is compatible for the dialect " outp)
        (display *dialect* outp)
        (newline outp)
        (display ";(c) Dorai Sitaram, Rice U., 1991, 1994" outp)
        (newline outp) (newline outp)
	;end banner

	(write `(define *op-sys*
		  ',(if (eq? *op-sys* 'dos) 'dos 'unix))
	  outp)
        (newline outp)

	;the following "compiles away" macros and modules.
	;the resulting code will sit in slatex.scm

        (newline)
	(display "Pass 1...") (newline)
	(for-each (lambda (f)
                    (display #\tab)
                    (display f) (newline)
		    (module:file-determine-locals f))
	  list-of-slatex-files)

        (newline)
        (display "Pass 2...") (newline)
	(for-each (lambda (f)
                    (display #\tab)
                    (display f) (newline)
		    (module:translate-file-to-port f outp))
	  list-of-slatex-files)))))

(newline)
(display "Beginning configuring SLaTeX for ")
(display *dialect*)
(display " on ")
(display *op-sys*)
(display " -- wait...")
(newline)

(generate-compatible-file
  (if (eq? *dialect* 'chez) "slatexsrc.scm" "slatex.scm"))

(if (eq? *dialect* 'chez)
    (begin
      (newline)
      (display "Getting compiled version for Chez Scheme...")
      (newline)
      (compile-file "slatexsrc.scm" "slatex.scm")
      ;(delete-file "slatexsrc.scm")
      (display "Finished compilation")
      (newline))
    'ok)

(newline)
(display "Finished configuring the SLaTeX Scheme file for your machine")
(newline)
(display "Read \"install\" for details on")
(newline)
(display "  1. which paths to place the SLaTeX files in")
(newline)
(display "  2. how to use the batch file, shell script, or Scheme script")
(newline)
(display "  that invokes SLaTeX")
(newline)
