;structs.ss
;SLaTeX Version 1.99
;Structures used by SLaTeX
;(c) Dorai Sitaram, December 1991, Rice University

(define *max-line-length* 200)

(defenum
  ;possible values of =space
  &void-space
  &plain-space
  &init-space
  &init-plain-space
  &paren-space
  &bracket-space
  &quote-space
  &inner-space)

(defenum
  ;possible values of =tab
  &void-tab
  &set-tab
  &move-tab
  &tabbed-crg-ret
  &plain-crg-ret)

(defenum
  ;possible values of =notab
  &void-notab
  &begin-comment
  &mid-comment
  &begin-string
  &mid-string
  &end-string
  &begin-math
  &mid-math
  &end-math)

(defrecord make-raw-line
  =rtedge =char =space =tab =notab)

(define make-line
  (lambda ()
    ;makes a "line" record 
    (let ((l (make-raw-line)))
      (setf (of l =rtedge) 0)
      (setf (of l =char) (make-string *max-line-length* *space*))
      (setf (of l =space) (make-string *max-line-length* &void-space))
      (setf (of l =tab) (make-string *max-line-length* &void-tab))
      (setf (of l =notab) (make-string *max-line-length* &void-notab))
      l)))

(define *line1* (make-line))
(define *line2* (make-line))

(defrecord make-case-frame 
  =in-ctag-tkn =in-bktd-ctag-exp =in-case-exp)

(defrecord make-bq-frame 
  =in-comma =in-bq-tkn =in-bktd-bq-exp)

(define *latex-paragraph-mode?* 'forward)

(define *intext?* 'forward)
(define *code-env-spec* "UNDEFINED")

(define *in* 'forward)
(define *out* 'forward)

(define *in-qtd-tkn* 'forward)
(define *in-bktd-qtd-exp* 'forward)

(define *in-mac-tkn* 'forward)
(define *in-bktd-mac-exp* 'forward)

(define *case-stack* 'forward)

(define *bq-stack* 'forward)

(define display-space
  (lambda (s p)
    (cond ((eq? s &plain-space) (display *space* p))
	  ((eq? s &init-plain-space) (display *space* p))
	  ((eq? s &init-space) (display "\\HL " p))
	  ((eq? s &paren-space) (display "\\PRN " p))
	  ((eq? s &bracket-space) (display "\\BKT " p))
	  ((eq? s &quote-space) (display "\\QUO " p))
	  ((eq? s &inner-space) (display "\\ " p)))))

(define display-tab
  (lambda (tab p)
    (cond ((eq? tab &set-tab) (display "\\=" p))
	  ((eq? tab &move-tab) (display "\\>" p)))))

(define display-notab
  (lambda (notab p)
    (cond ((eq? notab &begin-string) (display "\\dt{" p))
	  ((eq? notab &end-string) (display "}" p)))))

