;slaconfg.ss
;Configures SLaTeX for your Scheme 
;(c) Dorai Sitaram, December 1991, Rice University

(define *dialect* 'forward)
(define *op-sys* 'forward)
;(require 'pretty-print)

(call-with-input-file "config.dat"
  (lambda (p)
    (set! *dialect* (read p))
    (set! *op-sys* (read p))))

(if (not (memq *dialect* 
	  '(chez cscheme elk schemetoc scmj 
		umbscheme other)))
    (set! *dialect* 'other))

(if (not (memq *op-sys* '(dos unix other)))
    (set! *op-sys* 'other))

(define *return* (integer->char 13))
(define *newline* (integer->char 10))

(define eoln
  (cond ((eq? *op-sys* 'unix) (string *newline*))
  	((eq? *op-sys* 'dos) (string *return* *newline*))
  	(else (string *newline*))))

(define echo
  (lambda (p . z)
    (if p (for-each (lambda (x) (display x p)) z)
        (for-each display z))))

(if (not (memq *dialect* '(chez cscheme elk)))
    (define reverse!
      (lambda (s)
	;reverses list s inplace (i.e., destructively)
	(let loop ((s s) (r '()))
	  (if (null? s) r
	    (let ((d (cdr s)))
	      (set-cdr! s r)
	      (loop d s)))))))

(load "preproc.ss")

(define list-of-slatex-files
  (list
    "optchez.ss"
    "seqprocs.ss"
    "fileproc.ss"
    "lerror.ss"
    "defaults.ss"
    "helpers.ss"
    "structs.ss"
    "peephole.ss"
    "codeset.ss"
    "pathproc.ss"
    "texread.ss"
    "proctex.ss"
    "proctex2.ss"))

(define generate-compatible-file
  (lambda (output-file)

    (cond ((memq *dialect* '(chez cscheme scmj))
	   (if (file-exists? output-file)
	       (delete-file output-file) 'ok))
	  (else
	    (echo #f 
		  "If configuring fails following this sentence," eoln
		  "you most likely already have a slatex.ss in the current "
		  "directory." eoln
		  "Delete it and retry." eoln)))
	      
    (call-with-output-file output-file
      (lambda (out)
      
	;begin banner
	(echo out 
	      ";slatex.ss file generated using config.ss" eoln
	      ";This file is compatible for the dialect " *dialect* eoln
	      ";(c) dorai@rice.edu Dec. 1991" eoln eoln)
	;end banner

	(echo out
	      `(define *op-sys*
		 ',(if (eq? *op-sys* 'dos) 'dos 'unix))
	      eoln) ;if it isn't dos, assume it's unix-like

	(set! *module* '())
	(for-each
	  (lambda (file)
	    (echo #f "Module pass: " file eoln)
	    (module$call-on-file file
	      (lambda (e)
		(module$update (macro$expand e)))))
	  list-of-slatex-files)
	(set! *module* '())
	(for-each
	  (lambda (file)
	    (echo #f "Macro pass: " file eoln)
	    (module$call-on-file file
	      (lambda (e)
		(
		 write
		 ;pretty-print
		 (module$translate (macro$expand e)) out)
		(newline out))))
	  list-of-slatex-files)

	))))

(echo #f "Beginning configuring SLaTeX for " 
  *dialect* " on " *op-sys* " -- wait..." eoln)

(generate-compatible-file 
  (if (eq? *dialect* 'chez) "temp.ss" "slatex.ss"))

(if (eq? *dialect* 'chez)
    (begin 
      (echo #f 
	"Getting compiled version for Chez Scheme..." eoln)
      (compile-file "temp.ss" "slatex.ss")
      (delete-file "temp.ss")
      (echo #f "Finished compilation" eoln))
    'ok)

(echo #f 
  "Finished configuring SLaTeX for your machine" eoln
  "Read install.doc for details on" eoln
  "  a) which paths to place the SLaTeX files in" eoln
  "  b) how to modify the given batch file or shell script "
  "that invokes SLaTeX" eoln)

