;slaconfg.cl
;Configures SLaTeX for Common Lisp on your system
;(c) Dorai Sitaram, Nov. 1992

(defvar *dialect* 'cl) ;can't be anything else
(defvar *op-sys* 'forward)

(call-with-input-file "config.dat"
  #'(lambda (ip)
      (read ip) ;ignore dialect info
      (setq *op-sys* (read ip))))

(if (not (member *op-sys* '(dos unix other)))
    (setq *op-sys* 'other))

(defvar eoln
  (cond ((eq? *op-sys* 'dos)
         (scheme-string #\return #\newline))
        (else (scheme-string #\newline))))

(load "preproc.cl")

(defvar list-of-slatex-files
  (list
    "optchez.ss"
    "seqprocs.ss"
    "fileproc.ss"
    "lerror.ss"
    "defaults.ss"
    "helpers.ss"
    "structs.ss"
    "peephole.ss"
    "codeset.ss"
    "pathproc.ss"
    "texread.ss"
    "proctex.ss"
    "proctex2.ss"))

(defun generate-compatible-file (output-file)
  (if (file-exists? output-file) (delete-file output-file))
  (call-with-output-file output-file
    #'(lambda (op)
	(echo op ";slatex.ss file generated using config.ss" eoln)
	(echo op ";This file is compatible for Common Lisp" eoln)
	(echo op ";(c) dorai@rice.edu Dec. 1991" eoln)
	(module$call-on-file "rnrscl.cl"
	  #'(lambda (e)
	      (scheme-write e op) (newline op)))

	(echo op
	      `(defvar *op-sys* 
		 ',(if (eq *op-sys* 'dos) 'dos 'unix))
	      eoln)
	(echo op `(defmacro kludge z `'kludge) eoln)
    
	(setq *module* '())
	(for-each #'(lambda (file) 
		      (echo #f "Module pass: " file eoln)
		      (module$call-on-file file
			#'(lambda (e)
			    (module$update 
			      (macro$expand (macro$noclash e))))))
	  list-of-slatex-files)
	(setq *module* '())
	(for-each #'(lambda (file)
		      (echo #f "Macro pass: " file eoln)
		      (module$call-on-file file
			#'(lambda (e)
			    (print
			      (module$translate
				(macro$insert-funcalls
				  (macro$expand (macro$noclash e)))) op)
			    (terpri op))))
	  list-of-slatex-files))))

(echo #f "Beginning configuring SLaTeX for Common Lisp on " 
  *op-sys* " -- wait..." eoln)
(generate-compatible-file "slatex.ss")
(echo #f "Finished configuring SLaTeX for your machine" eoln)
(echo #f "   Read install.doc for details on" eoln)
(echo #f "     i. which paths to place the SLaTeX files in" eoln)
(echo #f "     ii. how to modify the given batch file or shell script"
  eoln)

