;rnrscl.cl
;For simulating RnRS in CL
;(c) Dorai Sitaram, December 1991, Rice University

(setq *print-case* :downcase)

; read #t and #f as t and nil resply

(set-dispatch-macro-character #\# #\t
  #'(lambda (ign1 ign2 ign3) t))

(set-dispatch-macro-character #\# #\f
  #'(lambda (ign1 ign2 ign3) nil))

(defmacro defun-alias (x y)
  `(setf (symbol-function ',x) (symbol-function ',y)))

(defvar else 'else)

;boolean?

(defun boolean? (b)
  (or (eq? b #t) (eq? b #f)))

;equivalence predicates

(defun-alias eq? eq)
(defun-alias eqv? eql)
(defun-alias equal? equal)

;pairs and lists

(defun-alias pair? consp)

(defun-alias set-car! rplaca)
(defun-alias set-cdr! rplacd)

(defun-alias null? null)

(defun list? (s)
    ;tests if s is a proper list;
    ;n.b. this is _not_ cl listp
  (cond ((null? s) #t)
        ((pair? s) (list? (cdr s)))
        (else #f)))

(defun-alias list-tail subseq) 

(defun-alias list-ref elt) 

(defun sequence-set! (s i v)
    ;sets the i-th element of sequence s to v
    ;not rnrs -- defined only as an auxiliary
    (setf (elt s i) v))

(defun-alias lisp-member member)

(defun memq (x s)
  (member x s :test #'eq?))

(defun-alias memv member)

(defun scheme-member (x s)
  (member x s :test #'equal?))

(defun-alias lisp-assoc assoc)

(defun assq (x s)
    (assoc x s :test #'eq?))

(defun-alias assv assoc)

(defun scheme-assoc (x s)
    (assoc x s :test #'equal?))

;symbols

(defun symbol? (x)
    ;like symbolp but scheme doesn't consider booleans to be symbols
    (and (symbolp x) (not (boolean? x))))

(defun string->symbol (s)
  ;make lowercase canonical, in contrast to CL
  (intern (string-upcase s)))

(defun symbol->string (x)
  ;make lowercase canonical -- see above
  (string-downcase (symbol-name x)))

;numerical operations

(defun-alias number? numberp)
(defun-alias complex? complexp)
(defun-alias real? floatp)
(defun-alias rational? rationalp)
(defun-alias integer? integerp)

(defun-alias zero? zerop)
(defun-alias positive? plusp)
(defun-alias negative? minusp)

(defun-alias odd? oddp)
(defun-alias even? evenp)

(defun quotient (m n)
  (truncate (/ m n)))
(defun-alias remainder rem)
(defun-alias modulo mod)

(defun-alias make-rectangular complex)
(defun make-polar (r th)
  (* r (cis th)))
(defun-alias real-part realpart)
(defun-alias imag-part imagpart)
(defun-alias magnitude abs)
(defun-alias angle phase)

;numerical input and output

(defun number->string (n &optional b)
    (if b (write-to-string n :base b)
	(write-to-string n)))

(defun string->number (s &optional b)
    (if b (let ((*read-base* b))
	    (with-input-from-string (p s)
	      (let ((n (read p)))
		(if (number? n) n #f))))
	(with-input-from-string (p s)
	  (let ((n (read p)))
	    (if (number? n) n  #f)))))

;characters

(defun-alias char? characterp)

(defun-alias char=? char=)
(defun-alias char<? char<)
(defun-alias char>? char>)
(defun-alias char<=? char<=)
(defun-alias char>=? char>=)

(defun-alias char-ci=? char-equal)
(defun-alias char-ci<? char-lessp)
(defun-alias char-ci>? char-greaterp)
(defun-alias char-ci<=? char-not-greaterp)
(defun-alias char-ci>=? char-not-lessp)

(defun-alias char-alphabetic? alpha-char-p)
(defun-alias char-numeric? digit-char-p)
(defun char-whitespace? (c)
    (or (char= c #\space) (char= c #\tab)
      (not (graphic-char-p c))))
(defun-alias char-upper-case? upper-case-p)
(defun-alias char-lower-case? lower-case-p)

(defun-alias char->integer char-int)
(defun-alias integer->char int-char)

;strings

(defun-alias string? stringp)

(defun scheme-make-string (n &optional c)
    (make-string n :initial-element (if c c #\space)))

(defun scheme-string (&rest z)
    (concatenate 'string z))

(defun-alias string-length length)

(defun-alias string-ref char)

(defun-alias string-set! sequence-set!)

(defun-alias string=? string=)
(defun-alias string<? string<)
(defun-alias string>? string>)
(defun-alias string<=? string<=)
(defun-alias string>=? string>=)

(defun-alias string-ci=? string-equal)
(defun-alias string-ci<? string-lessp)
(defun-alias string-ci>? string-greaterp)
(defun-alias string-ci<=? string-not-greaterp)
(defun-alias string-ci>=? string-not-lessp)

(defun-alias substring subseq)

(defun string-append (&rest z)
    (apply concatenate 'string z))

(defun string->list (s)
    (concatenate 'list s))

(defun list->string (s)
    (concatenate 'string s))

'(defun-alias string-copy copy-seq) ;seq proc

'(defun-alias string-fill! fill)

;vectors

(defun-alias vector? vectorp)

(defun make-vector (n &optional x)
    (make-array (list n) :initial-element x))

(defun-alias vector-length length)

(defun-alias vector-ref elt)

(defun-alias vector-set! sequence-set!)

(defun vector->list (v)
    (concatenate 'list v))    
  
(defun list->vector (s)
    (concatenate 'vector s))

'(defun-alias vector-fill! fill)

;control features

(defun procedure? (x)
  (cond ((symbol? x) #f)
        ((functionp x) #t)
        (else #f)))

(defun-alias scheme-map mapcar)

(defun-alias for-each mapc)

'(defun call-with-current-continuation  (r)
    ;n.b. continuations are downward only
    (let ((tag (gensym)))
      (catch tag
	(funcall r #'(lambda (v) (throw tag v))))))

;ports

(defun call-with-input-file (f pr)
    (with-open-file (p f :direction :input)
      (funcall pr p)))

(defun call-with-output-file (f pr)
    (with-open-file (p f :direction :output)
      (funcall pr p)))

(defun-alias input-port? input-stream-p)
(defun-alias output-port? output-stream-p)

(defun current-input-port () *standard-input*)
(defun current-output-port () *standard-output*)

'(defun with-input-from-file (f th)
    (call-with-input-file f
      #'(lambda (p)
	(let ((*standard-input* p)) ;fluid-let
	  (th)))))

'(defun with-output-to-file (f th)
    (call-with-output-file f
      #'(lambda (p)
	(let ((*standard-output* p)) ;fluid-let
	  (th)))))

(defun open-input-file (f)
    (open f :direction :input))

(defun open-output-file (f)
    (open f :direction :output))

(defun-alias close-input-port close)
(defun-alias close-output-port close)

;input

(defun scheme-read (&optional p)
    (read p #f :end-of-file))

(defun scheme-read-char (&optional p)
    (read-char p #f :end-of-file))

(defun scheme-peek-char (&optional p)
    (peek-char #f p #f :end-of-file))

(defun eof-object? (v)
    (eq? v :end-of-file))

'(defun char-ready? (&optional p)
    (let ((c (read-char-no-hang p #f #f)))
      (if c (progn (unread-char c i) #t)
	  #f)))

;output

(defun-alias scheme-write prin1)

(defun-alias display princ)

(defun-alias newline terpri)

;system interface

(defun-alias transcript-on dribble)
(defun-alias transcript-off dribble)

;some addl stuff

(defun-alias append! nconc)

(defun-alias reverse! nreverse)

(defun-alias list-set! sequence-set!)

(defun-alias file-exists? probe-file)

(defun echo (p &rest z)
  (if p (for-each #'(lambda (x) (display x p)) z)
      (progn (for-each #'display z) (force-output))))

(defun exit (&rest z)
  (if (fboundp 'bye) (bye)	
      (print "You may exit Common Lisp now!")))

;

(progn
  ;make all identifiers with symbol-functions also have the function
  ;as their symbol value
  (do-all-symbols (x)
    (cond ((boundp x) 'void)
	  ((macro-function x) 'void)
	  ((special-form-p x) 'void)
	  ((fboundp x) (setf (symbol-value x) (symbol-function x))))))
