;proctex.ss
;SLaTeX Version 1.99
;Implements SLaTeX's piggyback to LaTeX
;(c) Dorai Sitaram, December 1991, Rice University

(extern () process-main-tex-file)

(define process-tex-file 'forward)

(define disable-slatex-temply
  (lambda (in)
    ;tell slatex that it should not process slatex commands till
    ;the enabling control sequence is called
    (set! *slatex-enabled?* #f)
    (set! *slatex-reenabler* (read-grouped-latexexp in))))

(define enable-slatex-again
  (lambda ()
    ;tell slatex to resume processing slatex commands
    (set! *slatex-enabled?* #t)
    (set! *slatex-reenabler* "UNDEFINED")))

(define ignore2 
  (lambda (i ii)
    ;ignores its two arguments
    'void))

(define add-to-slatex-db
  (lambda (in categ)
    ;some scheme identifiers to be added to the token category categ
    (if (memq categ '(keyword constant variable))
	(add-to-slatex-db-basic in categ)
	(add-to-slatex-db-special in categ))))

(define add-to-slatex-db-basic
  (lambda (in categ)
    ;read the following scheme identifiers and add them to the
    ;token category categ
    (let ((setter (cond ((eq? categ 'keyword) set-keyword)
			((eq? categ 'constant) set-constant)
			((eq? categ 'variable) set-variable)
			(else (lerror 'add-to-slatex-db-basic))))
	  (ids (read-grouped-schemeids in)))
      (for-each setter ids))))

(define add-to-slatex-db-special
  (lambda (in what)
    ;read the following scheme identifier(s) and either
    ;enable/disable its special-symbol status
    (let ((ids (read-grouped-schemeids in)))
      (cond ((eq? what 'unsetspecialsymbol)
	     (for-each unset-special-symbol ids))
	    ((eq? what 'setspecialsymbol)
	     (if (= (length ids) 1) 'ok
	       (lerror 'setspecialsymbol-takes-one-arg-only))
	     (let ((transl (read-grouped-latexexp in)))
	       (set-special-symbol (car ids) transl)))
	    (else (lerror 'add-to-slatex-db-special 2))))))

(define process-slatex-alias
  (lambda (in what which)
    ;add/remove a slatex control sequence name
    (let ((triggerer (read-grouped-latexexp in)))
      (cond ((eq? which 'intext)
	     (set! *intext-triggerers* 
	       (what triggerer *intext-triggerers*)))
	    ((eq? which 'resultintext)
	     (set! *resultintext-triggerers*
	       (what triggerer *resultintext-triggerers*)))
	    ((eq? which 'display)
	     (set! *display-triggerers* 
	       (what triggerer *display-triggerers*)))
	    ((eq? which 'box)
	     (set! *box-triggerers* 
	       (what triggerer *box-triggerers*)))
	    ((eq? which 'input)
	     (set! *input-triggerers* 
	       (what triggerer *input-triggerers*)))
	    ((eq? which 'region)
	     (set! *region-triggerers* 
	       (what triggerer *region-triggerers*)))
	    ((eq? which 'mathescape)
	     (if (= (string-length triggerer) 1) 'ok
	       (lerror 'math-escape-should-be-character))
	     (set! *math-triggerers*
	       (what (string-ref triggerer 0) *math-triggerers*)))
	    (else (lerror 'process-slatex-alias))))))

(define decide-latex-or-tex
  (lambda (latex?)
    ;create a junk file if the file is in plain tex rather
    ;than latex; this is used afterward to call the right
    ;command, i.e., latex or tex
    (set! *latex?* latex?)
    (let ((pltexchk.jnk "pltexchk.jnk"))
      (if (file-exists? pltexchk.jnk) (delete-file pltexchk.jnk))
      (if (not *latex?*)
          (call-with-output-file pltexchk.jnk
            (lambda (op)
              (echo op 'junk eoln)))))))

(define process-include-only
  (lambda (in)
    ;remember the files mentioned by \includeonly
    (for-each
      (lambda (filename)
	(let ((filename (full-texfile-name filename)))
	  (if filename
	    (set! *include-onlys*
	      (adjoin-string filename *include-onlys*)))))
      (read-grouped-commaed-filenames in))))

(define process-documentstyle
  (lambda (in)
    ;process the .sty files corresponding to the documentstyle options
    (eat-latex-whitespace in)
    (if (char=? (peek-char in) #\[)
      (for-each
	(lambda (filename)
	  (fluid-let ((*slatex-in-protected-region?* #f))
	    (process-tex-file
	      (string-append filename ".sty"))))
	(read-bktd-commaed-filenames in)))))

(define process-case-info
  (lambda (in)
    ;find out and tell slatex if the scheme tokens that differ
    ;only by case should be treated identical or not
    (let ((bool (read-grouped-latexexp in)))
    (set! *slatex-case-sensitive?*
      (cond ((string-ci=? bool "true") #t)
	    ((string-ci=? bool "false") #f)
	    (else (lerror 'bad-schemecasesensitive-arg)))))))

(define seen-first-command? 'forward)

(define process-main-tex-file
  (lambda (filename)
    ;kick off slatex on the main .tex file filename
    (echo #f eoln "SLaTeX Version 1.9999, Dec. 1991" eoln)
    (set! *texinputs-list* (path->list *texinputs*))
    (let ((filehide.jnk "filehide.jnk"))
      (if (file-exists? filehide.jnk) (delete-file filehide.jnk))
      (if (eq? *op-sys* 'dos)
          (call-with-output-file filehide.jnk
            (lambda (out)
              (echo out "\\def\\filehider{x}" eoln)))))
     (echo #f "typesetting code")
    (set! jobname (basename filename ".tex"))
    (set! seen-first-command? #f)
    (process-tex-file filename)
    (echo #f "done" eoln eoln)))

(define dump-intext
  (lambda (in out)
    (let* ((display (if out display ignore2))
	   (delim-char (begin (eat-whitespace in) (read-char in)))
	   (delim-char
	     (cond ((char=? delim-char #\{) #\})
		   (else delim-char))))
      (if (eof-object? delim-char) (lerror 'dump-intext 1))
      (let loop ()
	(let ((c (read-char in)))
	  (if (eof-object? c) (lerror 'dump-intext 2))
	  (if (char=? c delim-char) 'done
              (begin (display c out) (loop))))))))
	      
(define dump-display
  (lambda (in out ender)
    (eat-tabspace in)
    (let ((display (if out display ignore2))
	  (ender-lh (string-length ender))
	  (c (peek-char in)))
      (if (eof-object? c) (lerror 'dump-display 1))
      (if (char=? c *newline*) (read-char in))
      (let loop ((buf ""))
	(let ((c (read-char in)))
	  (if (eof-object? c) (lerror 'dump-display 2))
	  (let ((buf (string-append buf (string c))))
	    (if (string-prefix? buf ender) 
		(if (= (string-length buf) ender-lh) 'done
		  (loop buf))
		(begin (display buf out) (loop "")))))))))

;continued on proctex2.ss
