;lerror.ss
;SLaTeX Version 1.99
;Display and error routines
;(c) Dorai Sitaram, December 1991, Rice University

(extern () exit)

(define *return* (integer->char 13))
(define *newline* #\newline)
(define *space* #\space)
(define *tab* (integer->char 9))

(define eoln
  (cond ((eq? *op-sys* 'unix) (string *newline*))
  	((eq? *op-sys* 'dos) (string *return* *newline*))
  	(else (string *newline*))))

(extract-if-not (cl)
  (define echo
    (lambda (p . z)
    ;displays the forms in z on port p;
    ;if p is false display to standard-output
      (if p (for-each (lambda (x) (display x p)) z)
	  (begin (for-each display z) (force-output))))))

(extract-if (chez elk schemetoc)
(define lerror
  (lambda z
    ;signal error, display forms in z on console, and collapse
    (display "Error: ")
    (for-each display z)
    (error #f ""))))

(extract-if-not (chez elk schemetoc)
(define lerror
  (lambda z
    (display "Error: ")
    (for-each display z)
    (error ""))))

(define lwarning
  (lambda z
    ;signal warning, display forms in z on console, but continue
    (display "Warning: ") (for-each display z) (display eoln)))

(extract-if (cscheme)
(define exit %exit))

(extract-if (other)
(define exit 
  (lambda z 
    (echo #f "Exit Scheme!" eoln))))