;batconfg.ss
;Configures SLaTeX batfile/shellscript (Scheme version)
;(c) Dorai Sitaram, Dec. 1991, Rice University

(define *dialect* 'forward)
(define *op-sys* 'forward) 
(define *scheme-pathname* 'forward)
(define *slatex-pathname* 'forward)
(define *texinputs* 'forward) 
(define *accepts-echo* 'forward)
(define *accepts-cmdline-file* 'forward) 
(define *accepts-initfile* 'forward) 
(define *file-deleter* 'forward)

(call-with-input-file "config.dat"
  (lambda (ip)
    (set! *dialect* (read ip))
    (set! *op-sys* (read ip)) 
    (set! *scheme-pathname* (read ip)) 
    (set! *slatex-pathname* (read ip)) 
    (set! *texinputs* (read ip)) 
    (set! *accepts-echo* (read ip))
    (set! *accepts-cmdline-file* (read ip)) 
    (set! *accepts-initfile* (read ip)) 
  ))

(if (not (memq *op-sys* '(dos unix other)))
    (set! *op-sys* 'other))

(define *file-deleter*
  (if (eq? *op-sys* 'dos) "del" "rm"))

(define *return* (integer->char 13))
(define *newline* (integer->char 10))

(define eoln
  (cond ((eq? *op-sys* 'unix) (string *newline*))
  	((eq? *op-sys* 'dos) (string *return* *newline*))
  	(else (string *newline*))))

(define echo
  (lambda (p . z)
    (if p (for-each (lambda (x) (display x p)) z)
        (for-each display z))))

(echo #f eoln "Beginning configuring batfile/shellscript"
  "  -- wait..." eoln)

(define *echo-delim* 
  (cond ((eq? *op-sys* 'dos) "")
        (else "'")))

(define *arg-mark*
  (cond ((eq? *op-sys* 'dos) "%")
        (else "$")))

(define *call-for-bat*
  (cond ((eq? *op-sys* 'dos) "call ")
	(else "")))

(define bat-file (if (eq? *op-sys* 'dos) "slatex.bat" "slatex"))

(if (memq *dialect* '(chez cscheme scmj))
    (if (file-exists? bat-file)
	(delete-file bat-file)))

(define op (open-output-file bat-file))

(if (eq? *op-sys* 'dos)
    (echo op "@echo off" eoln))

(cond ((and *accepts-echo* (eq? *op-sys* 'unix))
	;dos echos can't handle longish s-exps
       (echo op
        "echo " *echo-delim*
        "(load \"" *slatex-pathname* "\")"
        "(set! *texinputs* \"" *texinputs* "\")"
        "(process-main-tex-file \"" 
		*echo-delim* *arg-mark* 1 *echo-delim* "\")"
        *echo-delim*
	"|" *scheme-pathname* eoln))
      (*accepts-cmdline-file* 
       (echo op
        "echo " *echo-delim* 
        "(load \"" *slatex-pathname* "\")" 
        *echo-delim* " > slatex.jnk" eoln

	"echo " *echo-delim*
        "(set! *texinputs* \"" *texinputs* "\")"
        *echo-delim* " >> slatex.jnk" eoln

        "echo " *echo-delim*
        "(process-main-tex-file \""
		*echo-delim* *arg-mark* 1 *echo-delim* "\")"
        *echo-delim* " >> slatex.jnk" eoln

        "echo " *echo-delim* "(exit)" *echo-delim*
	  " >> slatex.jnk" eoln

        *call-for-bat* *scheme-pathname* " slatex.jnk" eoln

	*file-deleter* " slatex.jnk" eoln))
      (*accepts-initfile*
       (echo op
        "echo " *echo-delim*
        "(load \"" *slatex-pathname* "\")"
	*echo-delim* " > " *accepts-initfile* eoln
        
	"echo " *echo-delim*
	"(set! *texinputs* \"" *texinputs* "\")"
        *echo-delim* " >> " *accepts-initfile* eoln
	
	"echo " *echo-delim*
	"(process-main-tex-file \"" 
	*echo-delim* *arg-mark* 1 *echo-delim* "\")"
	*echo-delim* " >> " *accepts-initfile* eoln
		
	"echo " *echo-delim* "(exit)" *echo-delim*
        " >> " *accepts-initfile* eoln

       *call-for-bat* *scheme-pathname* eoln
       
       *file-deleter* " " *accepts-initfile* eoln))
      (else (echo #f "Your Scheme/system interface isn't "
	      "very cooperative" eoln)))

(cond ((eq? *op-sys* 'dos)
       (echo op
        "if exist pltexchk.jnk goto one" eoln
        "goto two" eoln
        ":one" eoln
        "call tex %1" eoln
	"del pltexchk.jnk" eoln
        "goto end" eoln
        ":two" eoln
        "call latex %1" eoln
        ":end" eoln))
      (else 
       (echo op
        "if test -f pltexchk.jnk" eoln
        "then tex $1; rm pltexchk.jnk" eoln
        "else latex $1" eoln
        "fi" eoln)))

(close-output-port op)

(if (memq *dialect* '(chez cscheme scmj))
    (if (file-exists? "callsla.ss")
	(delete-file "callsla.ss")))

(call-with-output-file "callsla.ss"
  (lambda (ip)
    (echo ip
	  "(load \"" *slatex-pathname* "\")" eoln
	  "(set! *texinputs* \"" *texinputs* "\")" eoln
	  "(define call-slatex (lambda (tex-file)" eoln
	  "  (process-main-tex-file tex-file)" eoln
	  "  (newline)" eoln
	  "  (display \"Call (la)tex on \")" eoln
	  "  (display tex-file)" eoln
	  "  (newline)))" eoln)))

(echo #f "Finished configuring batfile/shellscript"
  eoln)
(if (eq? *op-sys* 'unix)
  (echo #f "Type (chmod +x slatex) on Unix command line" eoln))