;batconfg.cl
;Configures SLaTeX batfile/shellscript (CL version)
;(c) Dorai Sitaram, Dec. 1991, Rice University

(set-dispatch-macro-character #\# #\t
  #'(lambda (ign1 ign2 ign3) t))

(set-dispatch-macro-character #\# #\f
  #'(lambda (ign1 ign2 ign3) nil))

(defvar *dialect* 'cl)
(defvar *op-sys* 'forward)
(defvar *scheme-pathname* 'forward)
(defvar *slatex-pathname* 'forward)
(defvar *texinputs* 'forward)
(defvar *accepts-echo* 'forward)
(defvar *accepts-cmdline-file* 'forward)
(defvar *accepts-initfile* 'forward)

(call-with-input-file "config.dat"
  #'(lambda (ip)
    (read ip) ;ignore dialect info
    (setq *op-sys* (read ip))
    (setq *scheme-pathname* (read ip))
    (setq *slatex-pathname* (read ip))
    (setq *texinputs* (read ip))
    (setq *accepts-echo* (read ip))
    (setq *accepts-cmdline-file* (read ip))
    (setq *accepts-initfile* (read ip))))

(if (not (memq *op-sys* '(dos unix other)))
    (setq *op-sys* 'other))

(defvar *file-deleter*
  (if (eq? *op-sys* 'dos) "del" "rm"))

(defvar eoln
  (cond ((eq? *op-sys* 'dos)
         (concatenate 'string (list #\return #\newline)))
        (else (concatenate 'string (list #\newline)))))

(echo #f eoln "Beginning configuring batfile/shellscript"
  "  -- wait..." eoln)

(defvar *echo-delim* 
  (cond ((eq? *op-sys* 'dos) "")
        (else "'")))

(defvar *arg-mark*
  (cond ((eq? *op-sys* 'dos) "%")
        (else "$")))

(defvar *call-for-bat*
  (cond ((eq? *op-sys* 'dos) "call ")
        (else "")))

(defvar bat-file (if (eq? *op-sys* 'dos) "slatex.bat" "slatex"))

(if (probe-file bat-file) (delete-file bat-file))

(defvar op (open bat-file :direction :output))

(if (eq? *op-sys* 'dos)
  (echo op "@echo off" eoln))

(cond ((and *accepts-echo* (eq? *op-sys* 'unix))
	;dos echos can't handle longish s-exps
       (echo op
        "echo " *echo-delim*
        "(load \"" *slatex-pathname* "\")"
        "(setq *texinputs* \"" *texinputs* "\")"
        "(process-main-tex-file \"" 
		*echo-delim* *arg-mark* 1 *echo-delim* "\")"
        *echo-delim* "|" *scheme-pathname* eoln))
      (*accepts-cmdline-file* 
       (echo op
        "echo " *echo-delim* 
        "(load \"" *slatex-pathname* "\")" 
        *echo-delim* " > slatex.jnk" eoln

        "echo " *echo-delim*
        "(setq *texinputs* \"" *texinputs* "\")"
        *echo-delim* " >> slatex.jnk" eoln

        "echo " *echo-delim*
        "(process-main-tex-file \""
		*echo-delim* *arg-mark* 1 *echo-delim* "\")"
        *echo-delim* " >> slatex.jnk" eoln

        "echo " *echo-delim* "(exit)" *echo-delim*
	  " >> slatex.jnk" eoln

         *call-for-bat* *scheme-pathname* " slatex.jnk" eoln

	 *file-deleter* " slatex.jnk" eoln))
      (*accepts-initfile*
       (echo op
        "echo " *echo-delim*
        "(load \"" *slatex-pathname* "\")"
	*echo-delim* " > " *accepts-initfile* eoln
        
	"echo " *echo-delim*
	"(setq *texinputs* \"" *texinputs* "\")"
        *echo-delim* " >> " *accepts-initfile* eoln
	
	"echo " *echo-delim*
	"(process-main-tex-file \"" 
	*echo-delim* *arg-mark* 1 *echo-delim* "\")"
	*echo-delim* " >> " *accepts-initfile* eoln
		
	"echo " *echo-delim*
	"(exit)"		
        *echo-delim*
        " >> " *accepts-initfile* eoln

	*call-for-bat* *scheme-pathname* eoln

	*file-deleter* " " *accepts-initfile* eoln))
      (else (echo #f "Your CL/system interface isn't "
	      "very cooperative" eoln)))

(cond ((eq? *op-sys* 'dos)
       (echo op
        "if exist pltexchk.jnk goto one" eoln
        "goto two" eoln
        ":one" eoln
        "call tex %1" eoln
	"del pltexchk.jnk" eoln
        "goto end" eoln
        ":two" eoln
        "call latex %1" eoln
        ":end" eoln))
      (else 
       (echo op
        "if test -f pltexchk.jnk" eoln
        "then tex $1; rm pltexchk.jnk" eoln
        "else latex $1" eoln
        "fi" eoln)))

(close op)

(if (probe-file "callsla.ss") (delete-file "callsla.ss"))

(call-with-output-file "callsla.ss"
  #'(lambda (ip)
    (echo ip
	  "(load \"" *slatex-pathname* "\")" eoln
	  "(setq *texinputs* \"" *texinputs* "\")" eoln
	  "(defun call-slatex (tex-file)" eoln
	  "  (process-main-tex-file tex-file)" eoln
	  "  (terpri)" eoln
	  "  (princ \"Call (la)tex on \")" eoln
	  "  (princ tex-file)" eoln
	  "  (terpri)))" eoln)))

(echo #f "Finished configuring batfile/shellscript" eoln)
(if (eq? *op-sys* 'unix)
  (echo #f "Type (chmod +x slatex) on Unix command line" eoln))
