;; traversedir.e - directory walking function
;; usage:
;;   (load "traverse.e")
;;      (traverse-p <path> <function>) 
;;   or (traverse <path> <function>)
;;   both call function with every file in path; 
;;   <function> takes one argument, the filename.
;; see examples below.
;; 
;; modified
;; 22sept


(if (not (bound? 'chdir)) (load "chdir.o"))
(if (not (bound? 'file-status)) (load "unix.o"))
(if (not (bound? 'sh)) (load "shell.e"))
(set! garbage-collect-notify? #f)


(define (traverse path dofile)

	;; helper
	(define (traverse-dir path dofile)
	  (let ((dir (read-directory path))
		(back (os-getwd)))
	;    (format #t "DIR: ~a~%" dir)
	    (format #t "traversing ~a~%" path)
	    (chdir path)
	    (dolist (entry dir)
		    (if (not (member entry '("." "..")))
			(traverse entry dofile)))
	    (chdir back)
	  );let
	);traverse-dir

  (if (equal? 'regular (file-status path))

      (dofile path)

      ; else
      (if (file-exists? path)		;dont try to read nonexistent links
	  (traverse-dir path dofile))
  )
);traverse


;; in this version the full path is kept in path, rather than chdiring
;; into each directory.
(define (traverse-p path dofile)

	(define (traverse-p-dir path dofile)
	  (let ((dir (read-directory path)))
	    (format #t "traversing ~a~%" path)
	    (dolist (entry dir)
		    (if (not (member entry '("." "..")))
			(traverse-p (string-append path "/" entry) dofile))
	    )
	  );let
	);traverse-p-dir

  (if (equal? 'regular (file-status path))

      (dofile path)

      ; else
      (if (file-exists? path)		;dont try to read nonexistent links
	  (traverse-p-dir path dofile))
  )
);traverse-p



(define (traverse-print path)
;  (system (string-append "ls -l " path))
  (print path))

(define (traversetest) (traverse "." traverse-print))


;; print recently created files
(define (shownew)
	(define seconds-per-day (* 60 60 24))
	(define (isnew? path)
	  (> (os-filemodtime path) (- (os-curtime) (* seconds-per-day))))
  (traverse "." (lambda (path) (if (isnew? path) (print path))))
);shownew


;; print time-sorted names of files created between after, before
(define (createdwhen after before)
  (if (not (bound? 'sort))
      (load "sort.scm" (global-environment)))
  (let ((matches '())
	(tmin (os-parsetime after))
	(tmax (os-parsetime before)))
    (if (or (= 0 tmin) (= 0 tmax))
	(error 'createdwhen "bad time"))
    (traverse "."
      (lambda (i)
	(let ((t (os-filemodtime i)))
	  (when (and (>= t tmin) (<= t tmax))
		(set! matches
		      (cons (list t (string-append (os-getwd) "/" i)) matches))
		(format #t "adding ~a ~a~%" i (os-timestring t))
	  );when
	);
      );lambda
    );traverse
    (set! matches (sort matches (lambda (a b) (> (car a) (car b)))))
    (dolist (i matches)
	    (format #t "~a	~a~%" (cadr i) (os-timestring (car i))))
  matches);let
);createdwhen
	      
	    
;; rm core files
(define (rmcores)
  (dolist (i (list (os-getenv "HOME") "/mm/zilla"))
    (traverse i
      (lambda (f)
        (when (equal? f "core")
	      (format #t ">>> ~a~%" f)
	)
      ))))


;; grep thru all c files in this tree
(define (grepthruC string)
  (traverse "."
    (lambda (f)
      (let ((l (string-length f)))
	(when (equal? ".c" (substring f (- l 2) l))
	      (print f)
	      (if (= (fsh "grep ~a ~a~%" string f) 0)
		  ;(print f)
		  #t
		  ;(got f)
	      )
	);when
      );let
    );lambda
  )
);grepthruC


;; grep thru all libraries in this tree
(define (grepthrulibs string)
  (traverse "."
    (lambda (f)
      (let ((len (string-length f)))
	(when (equal? ".a" (substring f (- len 2) len))
	      (print f)
	      (if (= (fsh "nm -o ~a | grep ~a~%" f string) 0)
		  ;(print f)
		  #t
		  ;(got f)
	      )
	);when
      );let
    );lambda
  )
);grepthrulibs
