/* Read and manage symbol tables from object modules
 */

#include "scheme.h"

#if defined(CAN_LOAD_OBJ) || defined (INIT_OBJECTS)

#ifdef MACH_O
#  include "stab-macho.c"
#else
#ifdef ELF
#  include "stab-elf.c"
#else
#if defined(COFF) || defined(XCOFF)
#  include "stab-coff.c"
#else
#ifdef ECOFF
#  include "stab-ecoff.c"
#else
#ifdef CONVEX_AOUT
#  include "stab-convex.c"
#else
#if defined(hp9000s300) || defined(__hp9000s300) || defined(__hp9000s300__)
#  include "stab-hp9k300.c"
#else
#if defined(hp9000s800) || defined(__hp9000s800) || defined(__hp9000s800__)
#  include "stab-hp9k800.c"
#else
#  include "stab-bsd.c"
#endif
#endif
#endif
#endif
#endif
#endif
#endif

Free_Symbols (tab) SYMTAB *tab; {
    register SYM *sp, *nextp;

    for (sp = tab->first; sp; sp = nextp) {
	nextp = sp->next;
#if defined(COFF) || defined(ECOFF)
	free (sp->name);
#endif
	free ((char *)sp);
    }
    if (tab->strings)
	free (tab->strings);
    free ((char *)tab);
}

static char *Ignore_Prefixes[] =  { "init__", "finit__",  0 };
static char *Init_Prefixes[] =  { "init_",  "__sti__", "_STI",
				  "_GLOBAL_$I$", 0 };
static char *Finit_Prefixes[] = { "finit_", "__std__", "_STD",
				  "_GLOBAL_$D$", 0 };

static FUNCT *Finalizers;

static void Call (l) unsigned long l; {
#ifdef XCOFF
    unsigned long vec[3];
    extern main();

    bcopy ((char *)main, (char *)vec, sizeof vec);
    vec[0] = l + (vec[0] & 0xF0000000);
    ((void (*)())vec)();
#else
    ((void (*)())l)();
#endif
}

Call_Initializers (tab, addr) SYMTAB *tab; char *addr; {
    register SYM *sp;
    register char *p, **pp;
    FUNCT *fp;

    for (sp = tab->first; sp; sp = sp->next) {
	if ((char *)sp->value < addr)
	    continue;
	p = sp->name;
#ifdef SYMS_BEGIN_WITH
	if (*p == SYMS_BEGIN_WITH)
	    p++;
	else
	    continue;
#endif
	for (pp = Ignore_Prefixes; *pp; pp++)
	    if (strncmp (p, *pp, strlen(*pp)) == 0)
		goto next;
	for (pp = Init_Prefixes; *pp; pp++) {
	    if (strncmp (p, *pp, strlen (*pp)) == 0) {
		if (Verb_Init)
		    printf ("[calling %s]\n", p);
		Call (sp->value);
	    }
	}
	for (pp = Finit_Prefixes; *pp; pp++) {
	    if (strncmp (p, *pp, strlen (*pp)) == 0) {
		fp = (FUNCT *)Safe_Malloc (sizeof (*fp));
		fp->func = (void (*)())sp->value;
		fp->name = Safe_Malloc (strlen (p) + 1);
		strcpy (fp->name, p);
		fp->next = Finalizers;
		Finalizers = fp;
	    }
	}
next: ;
    }
}

/* Call the finialization functions in reverse order.  Make sure that
 * calling exit() from a finalizer doesn't cause endless recursion.
 */
Call_Finalizers () {
    while (Finalizers) {
	FUNCT *fp = Finalizers;
	Finalizers = fp->next;
	if (Verb_Init)
	    printf ("[calling %s]\n", fp->name);
	Call ((unsigned long)fp->func);
    }
}
#endif /* CAN_LOAD_OBJ || INIT_OBJECTS */
