#ifndef MISC_H
#define MISC_H

#ifndef __GNUC__
#  define __asm__ asm
#endif

#ifndef HUGE
#  define HUGE HUGE_VAL
#endif

/* Arithmetic shift right for compilers that don't sign extend:
 */
#if (-1 >> 1) < 0
#  define ASR(n,s)    ((n) >>= (s))
#else
#  define NBITS(v)    ((sizeof v) * 8)
#  define HIBIT(v,n)  (NBITS(v) - (n))
#  define ASR(n,s)    ((n) >>= (s),\
			 ((n) & (1 << (HIBIT((n),(s)) - 1)) ?\
			    ((n) |= ~(((unsigned)1 << HIBIT((n),(s))) - 1)) :\
			    (n)))
#endif

#define Nullp(x)    (TYPE(x) == T_Null)
#define Truep(x)    (!EQ(x,False) && !EQ(x,False2))
#define Car(x)      PAIR(x)->car
#define Cdr(x)      PAIR(x)->cdr
#define Val(x)      Cdr(x) /* Obsolete! */
#define Cons        P_Cons
#define Begin       P_Begin
#define Assq(x,y)   General_Assoc(x,y,0)
#define Print(x)    General_Print_Object (x, Curr_Output_Port, 0)
#define Numeric(t)  (t == T_Fixnum || t == T_Flonum || t == T_Bignum)

#define Whitespace(c) (c == ' ' || c == '\t' || c == '\014' || c == '\n')
#define Delimiter(c) (c == ';' || c == ')' || c == '(' || c == '#' || c == '"')

#ifdef BSD_SIGNALS
#  ifndef sigmask
#    define sigmask(n)  (1 << ((n)-1))
#  endif
#  define Disable_Interrupts (void)sigblock (sigmask (SIGINT))
#  define Enable_Interrupts  (void)sigsetmask (0)
#else
#ifdef POSIX_SIGNALS
#  define Disable_Interrupts (void)sigprocmask (SIG_BLOCK, &Sigset_Block,\
	&Sigset_Old);
#  define Enable_Interrupts  (void)sigprocmask (SIG_SETMASK, &Sigset_Old,\
	(sigset_t *)0);
#else
#  define Disable_Interrupts (void)signal (SIGINT, SIG_IGN)
#  define Enable_Interrupts  {\
       if (!Intr_Was_Ignored) (void)signal (SIGINT, Intr_Handler);\
   }
#endif
#endif

/* Align heap addresses */
#ifdef ALIGN_8BYTE
#  define ALIGN(ptr) ((ptr) = (char *)(((int)(ptr) + 7) & ~7))
#else
#  define ALIGN(ptr) ((ptr) = (char *)(((int)(ptr) + 3) & ~3))
#endif

/* Normalize stack addresses */
#define NORM(addr)  ((int)(addr) + delta)

/* Used in special forms: */
#define TC_Prolog   register _t = Tail_Call
#define TC_Disable  Tail_Call = 0
#define TC_Enable   Tail_Call = _t

#define TAG_FUN    -1
#define TAG_TCFUN  -2
#define TAG_ARGS   -3
#define TAG_ENV    -4

#define GC_Node     GCNODE gc1
#define GC_Node2    GCNODE gc1, gc2
#define GC_Node3    GCNODE gc1, gc2, gc3
#define GC_Node4    GCNODE gc1, gc2, gc3, gc4
#define GC_Node5    GCNODE gc1, gc2, gc3, gc4, gc5
#define GC_Node6    GCNODE gc1, gc2, gc3, gc4, gc5, gc6

#define Tag_Node    GC_Node3

#define Tag_Link(args,fun,env) {\
    gc1.gclen = TAG_ARGS; gc1.gcobj = &args; gc1.next = GC_List;\
    gc2.gclen = Tail_Call ? TAG_TCFUN : TAG_FUN;\
	gc2.gcobj = &fun;  gc2.next = &gc1;\
    gc3.gclen = TAG_ENV;  gc3.gcobj = &env;  gc3.next = &gc2; GC_List = &gc3;\
}

#define Tag_Unlink  GC_Unlink

#define GC_Link(x) {\
    gc1.gclen = 0; gc1.gcobj = &x; gc1.next = GC_List; GC_List = &gc1;\
}

#define GC_Link2(x1,x2) {\
    gc1.gclen = 0; gc1.gcobj = &x1; gc1.next = GC_List;\
    gc2.gclen = 0; gc2.gcobj = &x2; gc2.next = &gc1; GC_List = &gc2;\
}

#define GC_Link3(x1,x2,x3) {\
    gc1.gclen = 0; gc1.gcobj = &x1; gc1.next = GC_List;\
    gc2.gclen = 0; gc2.gcobj = &x2; gc2.next = &gc1;\
    gc3.gclen = 0; gc3.gcobj = &x3; gc3.next = &gc2; GC_List = &gc3;\
}

#define GC_Link4(x1,x2,x3,x4) {\
    gc1.gclen = 0; gc1.gcobj = &x1; gc1.next = GC_List;\
    gc2.gclen = 0; gc2.gcobj = &x2; gc2.next = &gc1;\
    gc3.gclen = 0; gc3.gcobj = &x3; gc3.next = &gc2;\
    gc4.gclen = 0; gc4.gcobj = &x4; gc4.next = &gc3; GC_List = &gc4;\
}

#define GC_Link5(x1,x2,x3,x4,x5) {\
    gc1.gclen = 0; gc1.gcobj = &x1; gc1.next = GC_List;\
    gc2.gclen = 0; gc2.gcobj = &x2; gc2.next = &gc1;\
    gc3.gclen = 0; gc3.gcobj = &x3; gc3.next = &gc2;\
    gc4.gclen = 0; gc4.gcobj = &x4; gc4.next = &gc3;\
    gc5.gclen = 0; gc5.gcobj = &x5; gc5.next = &gc4; GC_List = &gc5;\
}

#define GC_Link6(x1,x2,x3,x4,x5,x6) {\
    gc1.gclen = 0; gc1.gcobj = &x1; gc1.next = GC_List;\
    gc2.gclen = 0; gc2.gcobj = &x2; gc2.next = &gc1;\
    gc3.gclen = 0; gc3.gcobj = &x3; gc3.next = &gc2;\
    gc4.gclen = 0; gc4.gcobj = &x4; gc4.next = &gc3;\
    gc5.gclen = 0; gc5.gcobj = &x5; gc5.next = &gc4;\
    gc6.gclen = 0; gc6.gcobj = &x6; gc6.next = &gc5; GC_List = &gc6;\
}

#define GC_Unlink (GC_List = gc1.next)

#define Global_GC_Link(x) Func_Global_GC_Link(&x)


#define Check_Type(x,t) {\
    if (TYPE(x) != t) Wrong_Type (x, t);\
}

#define Check_List(x) {\
    if (TYPE(x) != T_Pair && !Nullp (x)) Wrong_Type_Combination (x, "list");\
}

#define Check_Number(x) {\
    register t = TYPE(x);\
    if (!Numeric (t)) Wrong_Type_Combination (x, "number");\
}

#define Check_Integer(x) {\
    register t = TYPE(x);\
    if (t != T_Fixnum && t != T_Bignum) Wrong_Type (x, T_Fixnum);\
}

#define Check_Mutable(x) {\
    if (ISCONST(x))\
	Primitive_Error ("attempt to modify constant");\
}

#endif
