;;; -*- Scheme -*- PS9-SCAN.SCM

;;		     MASSACHUSETTS INSTITUTE OF TECHNOLOGY
;;	   Department of Electrical Engineering and Computer Science
;;	   6.001---Structure and Interpretation of Computer Programs
;;			     Fall Semester, 1992
;;
;;				 Problem Set 9


;;; ``Scan out'' internal defines as per section 5.2.5 of the course notes

(define (compile-lambda-body exp c-t-env proc-entry)
  (append-instruction-sequences
   (make-entry-point-designator proc-entry)
   (make-environment-switch (lambda-parameters exp))
   (compile-sequence
    (scan-out-defines (lambda-body exp))
    (extend-compile-time-env (lambda-parameters exp) c-t-env)
    'val
    'return)))

(define *scan-out-defines?* false)

(define (scan-out-defines lambda-body)
  (define (collect-definitions body names assignments)
    (cond ((null? body)
	   (error "scan-out-defines: Body contains only definitions"
		  lambda-body))
	  ((definition? (car body))
	   (let ((name  (definition-variable (car body)))
		 (value (definition-value    (car body))))
	     (collect-definitions (cdr body)
				  (cons name names)
				  (cons (list 'set! name value)
					assignments))))
	  (else
	   (cons (reverse names)
		 (append (reverse assignments)
			 body)))))
  (cond ((not *scan-out-defines?*)
	 lambda-body)
	(else
	 (let ((names+assigns-n-body (collect-definitions lambda-body '() '())))
	   (if (null? (car names+assigns-n-body))
	       (cdr names+assigns-n-body)
	       (list
		;; a poor man's LET
		(let ((params   (car name+assigns-n-body))
		      (new-body (cdr name+assigns-n-body)))
		  (cons (cons 'lambda (cons params new-body))
			(map (lambda (x) '*unassigned*) params)))))))))
