;;; Register machine implementation of the following Scheme procedure:

;;; An interesting Scheme procedure

(define (harm-proc n k)
  (define (loop n)
    (cond ((< n 2) n)
          (else
            (/ (+ (loop (-1+ n))
                  (loop (- n 2)))
               k))))
  (loop n))

;;; Its register machine implementation 

(define-machine harm
  (registers n-reg k-reg val continue)
  (controller
   (assign continue harm-done)
  harm-loop
   (branch (< (fetch n-reg) 2) harm-base)
  harm-left-branch
   (assign n-reg (-1+ (fetch n-reg)))
   (save continue)			; stack = rtn continue
   (save n-reg)				; stack = n-1 ; rtn continue
   (assign continue harm-right-branch)
   (goto harm-loop)			; (loop (-1+ n))
  harm-right-branch			; val = (loop (-1+ n))
   (restore n-reg)			; pop n-1
   (assign n-reg (-1+ (fetch n-reg)))		; compute n-2
   (save val)				; stack = (loop (-1+ n)) ; rtn continue
   (assign continue harm-scale-sum)
   (goto harm-loop)
 harm-scale-sum				; val = (loop (- n 2))
   (restore n-reg)			; hack: use n-reg for temp (loop (-1+ n))
   (assign val (+ (fetch n-reg) (fetch val))) ; stack = rtn continue
   (assign val (/ (fetch val) (fetch k-reg)))
   (restore continue)
   (goto (fetch continue))		; rtn w/ result in val
  harm-base
   (assign val (fetch n-reg))		; rtn w/ base value in val
   (goto (fetch continue))
  harm-done
   ;; fini
  ))

;;; Hand-coded data

(define (test-harm n k)
  (remote-assign harm 'n-reg n)
  (remote-assign harm 'k-reg k)
  (newline) (display "; Reseting... ignore this...")
  (initialize-graphics-window)		; maybe resized
  (initialize-stack       harm)		; reset mach state
  (initialize-ops-counter harm)
  (newline) (display (list 'computing: (list 'harm n k) '...))
  (start harm)
  (newline) (display "; Run complete: here are your stats...")
  (initialize-stack       harm)		; show mach state
  (initialize-ops-counter harm)
  (remote-fetch harm 'val)
  )

(define (plot-harm)
  (define divider ";;;----------------------------------------")
  (for-each (lambda (n)
	      (newline) (display divider)
	      (let ((val (test-harm n 1)))
		(newline) (display (list "Value =" val))))
	    '(0 1 2 3 4 5))
  (newline)
  (display divider)
  'done)

;;;(plot-harm)
;;;----------------------------------------
;;;(Computing (HARM 0 )...)
;;;(total-pushes = 0 maximum-depth = 0)
;;;(machine-ops = 4)
;;;----------------------------------------
;;;(Computing (HARM 1 )...)
;;;(total-pushes = 0 maximum-depth = 0)
;;;(machine-ops = 4)
;;;----------------------------------------
;;;(Computing (HARM 2 )...)
;;;(total-pushes = 3 maximum-depth = 2)
;;;(machine-ops = 23)
;;;----------------------------------------
;;;(Computing (HARM 3 )...)
;;;(total-pushes = 6 maximum-depth = 4)
;;;(machine-ops = 42)
;;;----------------------------------------
;;;(Computing (HARM 4 )...)
;;;(total-pushes = 12 maximum-depth = 6)
;;;(machine-ops = 80)
;;;----------------------------------------
;;;(Computing (HARM 5 )...)
;;;(total-pushes = 21 maximum-depth = 8)
;;;(machine-ops = 137)
;;;----------------------------------------
;Value: done

;;; Interpreted data

;;;----------------------------------------
;;;EC-EVAL==> 
;;;
;;;(harm 0 1)
;;;0
;;;(total-pushes = 29 maximum-depth = 8)
;;;(machine-ops = 259)
;;;----------------------------------------
;;;EC-EVAL==> 
;;;
;;;(harm 1 1)
;;;1
;;;(total-pushes = 29 maximum-depth = 8)
;;;(machine-ops = 259)
;;;----------------------------------------
;;;EC-EVAL==> 
;;;
;;;(harm 2 1)
;;;1.
;;;(total-pushes = 90 maximum-depth = 18)
;;;(machine-ops = 759)
;;;----------------------------------------
;;;EC-EVAL==> 
;;;
;;;(harm 3 1)
;;;2.
;;;(total-pushes = 151 maximum-depth = 28)
;;;(machine-ops = 1259)
;;;----------------------------------------
;;;EC-EVAL==> 
;;;
;;;(harm 4 1)
;;;3.
;;;(total-pushes = 273 maximum-depth = 38)
;;;(machine-ops = 2259)
;;;----------------------------------------
;;;EC-EVAL==> 
;;;
;;;(harm 5 1)
;;;5.
;;;(total-pushes = 456 maximum-depth = 48)
;;;(machine-ops = 3759)
;;;----------------------------------------

;;; Simply compiled data

;;; (compile-and-go 
;;;  '(define (harm n k)
;;;     (define (loop n)
;;;       (cond ((< n 2) n)
;;; 	    (else
;;; 	     (/ (+ (loop (-1+ n))
;;; 		   (loop (- n 2)))
;;; 		k))))
;;;     (loop n)))
;;; (total-pushes = 0 maximum-depth = 0)
;;; *undefined*
;;; (total-pushes = 1 maximum-depth = 1)
;;; (machine-ops = 25)
;;; ----------------------------------------
;;; EC-EVAL==> 
;;; 
;;; (harm 0 1)
;;; 0
;;; (total-pushes = 10 maximum-depth = 5)
;;; (machine-ops = 109)
;;; ----------------------------------------
;;; EC-EVAL==> 
;;; 
;;; (harm 1 1)
;;; 1
;;; (total-pushes = 10 maximum-depth = 5)
;;; (machine-ops = 109)
;;; ----------------------------------------
;;; EC-EVAL==> 
;;; 
;;; (harm 2 1)
;;; 1.
;;; (total-pushes = 26 maximum-depth = 8)
;;; (machine-ops = 221)
;;; ----------------------------------------
;;; EC-EVAL==> 
;;; 
;;; (harm 3 1)
;;; 2.
;;; (total-pushes = 42 maximum-depth = 13)
;;; (machine-ops = 333)
;;; ----------------------------------------
;;; EC-EVAL==> 
;;; 
;;; (harm 4 1)
;;; 3.
;;; (total-pushes = 74 maximum-depth = 18)
;;; (machine-ops = 557)
;;; ----------------------------------------
;;; EC-EVAL==> 
;;; 
;;; (harm 5 1)
;;; 5.
;;; (total-pushes = 122 maximum-depth = 23)
;;; (machine-ops = 893)
;;; ----------------------------------------




