(declare (usual-integrations))

;;;; Code for PS6.  This part of the code is compiled to make things
;;;; run faster. 

;;; this code was modified for Scheme by Joseph Boerjes for 6.001  
;;; original lisp code provided by Daniel Huttenlocher with copyrights
;;; as explained below. 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; -*- mode: lisp; syntax: common-lisp; package:(match scl) -*-           ;
;;;                                                                        ;
;;; copyright (c) 1988, 1989, 1990 daniel huttenlocher                     ;
;;;                                                                        ;
;;; this code may not be used for commercial purposes without the written  ;
;;; permission of the author.                                              ;
;;;                                                                        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-structure (2d-pt (copier copy-2d-pt)) 
  x 
  y)

(define (make-2d-point x y)
  (make-2d-pt x y))

(define-structure (3d-pt (copier copy-3d-pt))
  x
  y 
  z)

(define (make-3d-point x y z)
  (make-3d-pt x y z))

(define-structure (3d-matrix (copier copy-3d-matrix))
  r11 
  r12 
  r13 
  r21 
  r22 
  r23 
  r31 
  r32
  r33)

(define-structure (2d-matrix (copier copy-2d-matrix))
  l11 
  l12 
  l21 
  l22)

(define-structure (alignment-transform (copier copy-altr))
  (matrix (make-3d-matrix))
  (translation (make-2d-point 0 0)))

;;; vector and support functions

(define (sq x)
  (* x x))

(define (fix-v vect)
  (make-2d-point (round (2d-pt-x vect)) (round (2d-pt-y vect))))

(define (vcross3 x y)
  (make-3d-point
   (- (* (3d-pt-y x) (3d-pt-z y)) (* (3d-pt-z x) (3d-pt-y y)))
   (- (* (3d-pt-z x) (3d-pt-x y)) (* (3d-pt-x x) (3d-pt-z y)))
   (- (* (3d-pt-x x) (3d-pt-y y)) (* (3d-pt-y x) (3d-pt-x y)))))

(define (vadd3 v1 v2)
  (make-3d-point 
   (+ (3d-pt-x v1) (3d-pt-x v2))
   (+ (3d-pt-y v1) (3d-pt-y v2))
   (+ (3d-pt-z v1) (3d-pt-z v2))))

(define (vdiff3 v1 v2)
  (make-3d-point
   (- (3d-pt-x v1) (3d-pt-x v2))
   (- (3d-pt-y v1) (3d-pt-y v2))
   (- (3d-pt-z v1) (3d-pt-z v2))))

(define (vscale3 c l)
  (make-3d-point
   (* c (3d-pt-x l)) 
   (* c (3d-pt-y l)) 
   (* c (3d-pt-z l))))

(define (vdot3 v1 v2)
  (+ (* (3d-pt-x v1) (3d-pt-x v2))
     (* (3d-pt-y v1) (3d-pt-y v2))
     (* (3d-pt-z v1) (3d-pt-z v2))))

(define (vunit3 v)
  (vscale3 (/ 1.0 (sqrt (vdot3 v v))) v))

(define (vdot2 v1 v2)
  (+ (* (2d-pt-x v1) (2d-pt-x v2))
     (* (2d-pt-y v1) (2d-pt-y v2))))

(define (vscale2 c v)
  (make-2d-point (* c (2d-pt-x v))
		 (* c (2d-pt-y v))))

(define (vunit2 v)
  (vscale2 (/ 1.0 (sqrt (vdot2 v v))) v))

(define (vdiff2 tip bas)
  (make-2d-point 
   (- (2d-pt-x tip) (2d-pt-x bas))
   (- (2d-pt-y tip) (2d-pt-y bas))))

(define (vadd2 v1 v2)
  (make-2d-point
   (+ (2d-pt-x v1) (2d-pt-x v2))
   (+ (2d-pt-y v1) (2d-pt-y v2))))

(define (vsub2 v1 v2)
  (make-2d-point 
   (- (2d-pt-x v1) (2d-pt-x v2))
   (- (2d-pt-y v1) (2d-pt-y v2))))

(define (3d->2d-pt point)
  (make-2d-point
  (3d-pt-x point) 
   (3d-pt-y point)))

(define (2d->3d-pt point)
  (make-3d-point 
   (2d-pt-x point) 
   (2d-pt-y point)
    0))

(define (square x) (* x x))

(define (vdist2 v1 v2)
  (sqrt (+ (square (- (2d-pt-x v1) (2d-pt-x v2)))
	   (square (- (2d-pt-y v1) (2d-pt-y v2))))))



(define (determinant-3d matrix)
  (+ (* (3d-matrix-r11 matrix)
	(- (* (3d-matrix-r22 matrix) (3d-matrix-r33 matrix))
	   (* (3d-matrix-r23 matrix) (3d-matrix-r32 matrix))))
     (- (* (3d-matrix-r12 matrix)
	   (- (* (3d-matrix-r21 matrix) (3d-matrix-r33 matrix))
	      (* (3d-matrix-r23 matrix) (3d-matrix-r31 matrix)))))
     (* (3d-matrix-r13 matrix)
	(- (* (3d-matrix-r21 matrix) (3d-matrix-r32 matrix))
	   (* (3d-matrix-r22 matrix) (3d-matrix-r31 matrix))))))


;; below is a new version of the rotation to the plane code

(define (rotation-to-z=0-plane bt ct)
  (let* ((p (vcross3 bt ct))
	 (r (if (and (zero? (3d-pt-x p))
		     (zero? (3d-pt-y p)))
		;; already okay
		(vunit3 p)
		(vunit3 (vadd3 (vunit3 p) (make-3d-point 0 0 1)))))
	 (rotation-matrix
	   (make-3d-matrix
	     (+ -1 (* 2 (sq (3d-pt-x r))))
	     (* 2 (3d-pt-x r) (3d-pt-y r))
	     (* 2 (3d-pt-x r) (3d-pt-z r))
	     (* 2 (3d-pt-x r) (3d-pt-y r))
	     (+ -1 (* 2 (sq (3d-pt-y r))))
	     (* 2 (3d-pt-y r) (3d-pt-z r))
	     (* 2 (3d-pt-x r) (3d-pt-z r))
	     (* 2 (3d-pt-y r) (3d-pt-z r))
	     (+ -1 (* 2 (sq (3d-pt-z r)))))))
    rotation-matrix))

(define (2d-linear-transform b c b1 c1)
  (let ((det  (- (* (2d-pt-x c) (2d-pt-y b)) 
		       (* (2d-pt-x b) (2d-pt-y c)))))
    (if (= det 0)
	(error "matrix is singular" )  ;;;;;;;(throw 'singular 'singular)
	(make-2d-matrix
	  (/ (- (* (2d-pt-x c1) (2d-pt-y b)) 
		(* (2d-pt-x b1) (2d-pt-y c))) det)
	  (/ (- (* (2d-pt-x b1) (2d-pt-x c))
		(* (2d-pt-x c1) (2d-pt-x b))) det)
	  (/ (- (* (2d-pt-y c1) (2d-pt-y b))
		(* (2d-pt-y b1) (2d-pt-y c))) det)
	  (/ (- (* (2d-pt-x c) (2d-pt-y b1)) 
		(* (2d-pt-x b) (2d-pt-y c1))) det)))))

(define (2d-affine-transform am bm cm ai bi ci)
  (let ((l (2d-linear-transform
	    (vsub2 bm am) 
	    (vsub2 cm am)
	    (vsub2 bi ai)
	    (vsub2 ci ai))))
    (list l (vadd2 (transform-2d (vscale2 -1 am) l) ai))))

(define (2d-affine-transform-pt pt trans)
  (vadd2 (cadr trans) (transform-2d pt (car trans))))

(define (3d-scaled-rotation-from-2d-linear-transform l neg-c1c2)
  (let ((l11 (2d-matrix-l11 l))
	(l12 (2d-matrix-l12 l))
	(l21 (2d-matrix-l21 l))
	(l22 (2d-matrix-l22 l)))
    (let* ((w (- (+ (sq l12) (sq l22)) (+ (sq l11) (sq l21))))
	   (q (+ (* l11 l12) (* l21 l22)))
	   (c1 (sqrt (* .5 (+ w (sqrt (+ (sq w) (* 4 (sq q))))))))
	   (c2 (if (= c1 0) (sqrt (abs w)) (/ (- q) c1)))
	   (scale (sqrt (+ (sq l11) (sq l21) (sq c1)))))
      (if neg-c1c2
	  (begin
	    (set! c1 (- c1))
	    (set! c2 (- c2)))
	  false)
      (make-3d-matrix l11
		      l12
		      (/ (- (* c2 l21) (* c1 l22)) scale)
		      l21
		      l22
		      (/ (- (* c1 l12) (* c2 l11)) scale)
		      c1
		      c2
		      (/ (- (* l11 l22) (* l21 l12)) scale)))))

(define (compose-alignment-transform rotation-1 translation-1 
				     rotation-2 translation-2)
  (let* ((alignment (make-alignment-transform (make-3d-matrix 0 0 0
							      0 0 0
							      0 0 0)
					      (make-2d-point 0 0)))
	 (matrix (alignment-transform-matrix alignment)))
    (set-3d-matrix-r11! matrix
			(+ (* (3d-matrix-r11 rotation-1)
			      (3d-matrix-r11 rotation-2))
			   (* (3d-matrix-r21 rotation-1) 
			      (3d-matrix-r12 rotation-2))
			   (* (3d-matrix-r31 rotation-1) 
			      (3d-matrix-r13 rotation-2))))
    (set-3d-matrix-r21! matrix
			(+ (* (3d-matrix-r11 rotation-1) 
			      (3d-matrix-r21 rotation-2))
			   (* (3d-matrix-r21 rotation-1)
			      (3d-matrix-r22 rotation-2))
			   (* (3d-matrix-r31 rotation-1)
			      (3d-matrix-r23 rotation-2))))
    (set-3d-matrix-r31! matrix
			(+ (* (3d-matrix-r11 rotation-1) 
			      (3d-matrix-r31 rotation-2))
			   (* (3d-matrix-r21 rotation-1) 
			      (3d-matrix-r32 rotation-2))
			   (* (3d-matrix-r31 rotation-1) 
			      (3d-matrix-r33 rotation-2))))
    (set-3d-matrix-r12! matrix
			(+ (* (3d-matrix-r12 rotation-1) 
			      (3d-matrix-r11 rotation-2))
			   (* (3d-matrix-r22 rotation-1) 
			      (3d-matrix-r12 rotation-2))
			   (* (3d-matrix-r32 rotation-1) 
			      (3d-matrix-r13 rotation-2))))
    (set-3d-matrix-r22! matrix
			(+ (* (3d-matrix-r12 rotation-1) 
			      (3d-matrix-r21 rotation-2))
			   (* (3d-matrix-r22 rotation-1)
			      (3d-matrix-r22 rotation-2))
			   (* (3d-matrix-r32 rotation-1) 
			      (3d-matrix-r23 rotation-2))))
    (set-3d-matrix-r32! matrix
			(+ (* (3d-matrix-r12 rotation-1) 
			      (3d-matrix-r31 rotation-2))
			   (* (3d-matrix-r22 rotation-1) 
			      (3d-matrix-r32 rotation-2))
			   (* (3d-matrix-r32 rotation-1) 
			      (3d-matrix-r33 rotation-2))))
    (set-3d-matrix-r13! matrix
			(+ (* (3d-matrix-r13 rotation-1) 
			      (3d-matrix-r11 rotation-2))
			   (* (3d-matrix-r23 rotation-1) 
			      (3d-matrix-r12 rotation-2))
			   (* (3d-matrix-r33 rotation-1)
			      (3d-matrix-r13 rotation-2))))
    (set-3d-matrix-r23! matrix
			(+ (* (3d-matrix-r13 rotation-1) 
			      (3d-matrix-r21 rotation-2))
			   (* (3d-matrix-r23 rotation-1) 
			      (3d-matrix-r22 rotation-2))
			   (* (3d-matrix-r33 rotation-1)
			      (3d-matrix-r23 rotation-2))))
    (set-3d-matrix-r33! matrix
			(+ (* (3d-matrix-r13 rotation-1) 
			      (3d-matrix-r31 rotation-2))
			   (* (3d-matrix-r23 rotation-1) 
			      (3d-matrix-r32 rotation-2))
			   (* (3d-matrix-r33 rotation-1) 
			      (3d-matrix-r33 rotation-2))))
    (let ((strans (transform-3d translation-1 matrix)))
      (set-alignment-transform-translation! alignment
	    (make-2d-point 
	     (+ (3d-pt-x strans) (2d-pt-x translation-2))
	     (+ (3d-pt-y strans) (2d-pt-y translation-2)))))
    alignment))

(define (transform-3d 3d-pt matrix)
  (let ((x (3d-pt-x 3d-pt))
	(y (3d-pt-y 3d-pt))
	(z (3d-pt-z 3d-pt)))
    (make-3d-point 
     (+ (* (3d-matrix-r11 matrix) x)
	(* (3d-matrix-r12 matrix) y)
	(* (3d-matrix-r13 matrix) z))
     (+ (* (3d-matrix-r21 matrix) x)
	(* (3d-matrix-r22 matrix) y)
	(* (3d-matrix-r23 matrix) z))
     (+ (* (3d-matrix-r31 matrix) x)
	(* (3d-matrix-r32 matrix) y)
	(* (3d-matrix-r33 matrix) z)))))

(define (transform-2d 2d-pt matrix)
  (let ((x (2d-pt-x 2d-pt))
	(y (2d-pt-y 2d-pt)))
    (make-2d-point
     (+ (* (2d-matrix-l11 matrix) x)
	(* (2d-matrix-l12 matrix) y))
     (+ (* (2d-matrix-l21 matrix) x)
	(* (2d-matrix-l22 matrix) y)))))



(define make-vector (access make-vector (->environment '(student pictures))))
(define floating-vector-ref (access floating-vector-ref (->environment '(student pictures))))
(define floating-vector-cons (access floating-vector-cons (->environment '(student pictures))))
(define floating-vector-set! (access floating-vector-set! (->environment '(student pictures))))
(define picture-data (access picture-data (->environment '(student pictures))))
(define picture-height (access picture-height (->environment '(student pictures))))
(define picture-width (access picture-width (->environment '(student pictures))))
(define picture-set! (access picture-set! (->environment '(student pictures))))


;;; Computing the distance transform

(define (distance-transform picture)
  (let ((height (picture-height picture))
	(width (picture-width picture))
	(dscale 1.)
	(infinity 640000.))
    (let ((new-pic (make-picture width height)))
      (let ((new-pic-data (picture-data new-pic))
	    (picdata (picture-data picture)))
	(define (copy-column x data)
	    (let ((column (floating-vector-cons height)))
	      (do
		  ((y 0 (fix:+ y 1)))
		  ((fix:= y height))
		(floating-vector-set! column y (floating-vector-ref (vector-ref data y) x)))
	      column))
	(define (right-x-iter x y minval)
	  (let ((row (vector-ref picdata y))
		(new-row (vector-ref new-pic-data y)))
	    (let loop ((x x) (minval minval))
	      (if (fix:< x width)
		  (let ((minval
			 (if (flo:= (floating-vector-ref row x) 0.0)
			     0.0
			     (flo:+ minval 1.))))
		    (floating-vector-set! new-row x minval)
		    (loop (fix:+ x 1) minval))))))	
	(define (left-x-iter x y minval)
	  (let ((row (vector-ref picdata y))
		(new-row (vector-ref new-pic-data y)))
	    (let loop ((x x) (minval minval))
	      (if (fix:>= x 0)
		  (let ((minval
			 (if (flo:= (floating-vector-ref row x) 0.0)
			     0.0
			     (min (flo:+ minval 1.) 
				  (floating-vector-ref new-row x)))))
		    (floating-vector-set! new-row x minval)
		    (loop (fix:- x 1) minval))))))
	(define (iter-x x width)
	  (let ((mf 0)
		(mo 0)
		(minval)
		(dftval (floating-vector-cons height))
		(dftrow (make-vector height))
		(column (copy-column x new-pic-data)))  ;;; should this be picture or new-pic
	    (let y-loop ((y 0))
	      (if (fix:< y height)
		  (begin
		    (if (flo:< (floating-vector-ref column y) infinity)
			(begin 
			  (floating-vector-set! dftval mf 
						(let ((x (floating-vector-ref column y)))
						  (flo:* x x)))
			  (vector-set! dftrow mf y)
			  (set! mf (fix:+ mf 1)))
			'done)
		    (let w-loop ((w mf))   ;;; w is Mf
		      (if (and (fix:> w (fix:+ mo 1))
			       (not (flo:> (floating-vector-ref dftval (fix:- w 1))
					   (floating-vector-ref dftval (fix:- w 2)))))
			  (begin
			    (set! mf (fix:- mf 1))
			    (floating-vector-set! dftval (fix:- mf 1)
						  (floating-vector-ref dftval mf))
			    (vector-set! dftrow (fix:- mf 1) (vector-ref dftrow mf))
			    (w-loop (fix:- w 1)))
			  'done))
		    (if (fix:= mf mo)
			(floating-vector-set! (vector-ref new-pic-data y)
					      x infinity))
		    (set! minval
			  (flo:+ (floating-vector-ref dftval mo)
				 (exact->inexact (let ((x (fix:- (vector-ref dftrow mo) y)))
						   (fix:* x x)))))
		    (let m-loop ((m (fix:+ mo 1)))
		      (if (fix:< m mf)
			  (begin
			    (set! minval (min minval 
					      (flo:+ (floating-vector-ref dftval m)
						     (exact->inexact
						      (let ((x (fix:- (vector-ref dftrow m) y)))
							(fix:* x x))))))
			    (m-loop (fix:+ m 1)))
			  'done))
		    (floating-vector-set! (vector-ref new-pic-data y) x minval)
		    (let w-loop ((w mo))
		      (if (< minval
			     (let ((x (fix:- y (vector-ref dftrow w))))
			       (fix:* x x)))
			  (begin
			    (set! mo (fix:+ mo 1))
			    (w-loop (fix:+ w 1)))
			  'done))
		    (y-loop (fix:+ y 1)))
		  'done))
	    (let y-loop-2 (( y (fix:- height 1)))
	      (if (fix:>= y 0)
		  (begin
		    (if (flo:< (floating-vector-ref column y) infinity)
			(begin 
			  (floating-vector-set! dftval mf 
						(let ((x (floating-vector-ref column y)))
						  (flo:* x x)))
			  (vector-set! dftrow mf y)
			  (set! mf (fix:+ mf 1)))
			'done)
		    (let w-loop ((w mf))   ;;; w is Mf
		      (if (and (fix:> w (fix:+ mo 1))
			       (not (flo:> (floating-vector-ref dftval (fix:- w 1))
					   (floating-vector-ref dftval (fix:- w 2)))))
			  (begin
			    (set! mf (fix:- mf 1))
			    (floating-vector-set! dftval (fix:- mf 1)
						  (floating-vector-ref dftval mf))
			    (vector-set! dftrow (fix:- mf 1) (vector-ref dftrow mf))
			    (w-loop (fix:- w 1)))
			  'done))
		    (if (fix:= mf mo)
			(floating-vector-set! 
			 (vector-ref new-pic-data y)
			 x (flo:* dscale
;				  (sqrt 
				   (floating-vector-ref
				    (vector-ref new-pic-data y) x) ;)
				   )))
		    (set! minval (flo:+ (floating-vector-ref dftval mo)
					(exact->inexact 
					 (let ((x (fix:- (vector-ref dftrow mo) y)))
					   (fix:* x x)))))
		    (let m-loop ((m (fix:+ mo 1)))
		      (if (fix:< m mf)
			  (begin
			    (set! minval (min minval 
					      (flo:+ (floating-vector-ref dftval m)
						     (exact->inexact
						      (let ((x (fix:- (vector-ref dftrow m) y)))
							(fix:* x x))))))
			    (m-loop (fix:+ m 1)))
			  'done))
		    (floating-vector-set! (vector-ref new-pic-data y)
					  x (flo:* dscale
;						   (sqrt
						    (min minval 
							      (floating-vector-ref
							       (vector-ref new-pic-data y) x)); )
						   ))
		    (let w-loop ((w mo))
		      (if (< minval
			     (let ((x (fix:- y (vector-ref dftrow w))))
			       (fix:* x x)))
			  (begin
			    (set! mo (fix:+ mo 1))
			    (w-loop (fix:+ w 1)))
			  'done))
		    (y-loop-2 (fix:- y 1)))
		  'done))
	    (if (fix:< x (fix:- height 1))
		(begin
		  (iter-x (fix:+ x 1) width))
		'done)))
	(define (iter-y y height)
	  (if (fix:< y height)
	      (begin
		(right-x-iter 1 y 
			      (floating-vector-ref
			       (vector-ref picdata y) 0))
		(left-x-iter (fix:- width 2) y 
			     (floating-vector-ref
			      (vector-ref picdata y) (fix:- width 1)))
		(iter-y (fix:+ 1 y) height))
	      'done))
	(iter-y 0 height)
	(iter-x 0 width)
	new-pic))))


	     
(define (check-segment segment dtrans delta) 
  (let* ((data ((access picture-data 
			(->environment '(student pictures)))
		dtrans))
	 (height ((access picture-height 
			(->environment '(student pictures)))
		dtrans))
	 (width ((access picture-width 
			(->environment '(student pictures)))
		dtrans))
	 (start (seg-start segment))
	 (end (seg-end segment))
	 (incr (vunit2 (vdiff2 end start)))
	 (xincr (2d-pt-x incr))
	 (yincr (2d-pt-y incr))
	 (lng (round->exact (vdist2 end start)))
	 (x (2d-pt-x start))
	 (y (2d-pt-y start)))
    (let loop ((i 0))
	    (if (check-point (round->exact x) (round->exact y) width height data delta)
		(if (> i lng)
		    true
		    (begin
                      (set! y (+ y yincr))
		      (set! x (+ x xincr))
		      (loop (fix:+ i 1))))
		false))))

(define (check-point x y width height data delta)
    (and (fix:>= x 0)
	 (fix:>= y 0)
	 (fix:< x width)
	 (fix:< y height)
	 (< (floating-vector-ref (vector-ref data y) x) delta)))


;;;more stuff

;; procedure for finding the centroid of a list of segments

(define (compute-centroid seg-lst)
  (let ((seg-mids (map (lambda (x) (vscale2 .5
					    (vadd2 (seg-start x) (seg-end x))))
			seg-lst))
	(lng (length seg-lst)))
    (make-2d-point (/ (apply + (map 2d-pt-x seg-mids)) lng)
		   (/ (apply + (map 2d-pt-y seg-mids)) lng))))

;; procedure for converting a segment list to a picture

(define (segments->picture segl)
  (let ((width 128)
	(height 128)
	(picture (make-picture 128 128 255)))
    (define (draw-seg-in-picture picture start end)
      (let* ((value (exact->inexact 0))			;black
	     (xs (2d-pt-x start))
	     (ys (2d-pt-y start))
	     (xe (2d-pt-x end))
	     (ye (2d-pt-y end))
	     (xinc (if (< xs xe) 1 -1))
	     (dx (round->exact (abs (- xs xe))))
	     (yinc (if (< ys ye) 1 -1))
	     (dy (round->exact (abs (- ys ye))))
	     (dx2 (* dx 2))
	     (dy2 (* dy 2))
	     (x (round->exact xs))
	     (y (round->exact ys)))
	(define (plot-if-in-picture x y picture value)
	  (if (and (fix:>= x 0)
		   (fix:>= y 0)
		   (fix:< x width)
		   (fix:< y height))
	      (picture-set! picture x y value)))
	(plot-if-in-picture x y picture value)
	(if (> dx dy)
	    (let ((dxy (- dy2 dx2)) 
		  (s (- dy2 dx)))
	      (let loop ((i 1))
		(if (fix:> i dx)
		    'done
		    (begin
		      (if (fix:>= s 0)
			  (begin (set! y (fix:+ y yinc))
				 (set! s (fix:+ s dxy)))
			  (set! s (fix:+ s dy2)))
		      (set! x (fix:+ x xinc))
		      (plot-if-in-picture x y picture value)
		      (loop (fix:+ i 1))))))
	    (let ((dxy (- dx2 dy2)) 
		  (s (- dx2 dy)))
	      (let loop ((i 1))
		(if (fix:> i dy)
		    'done
		    (begin
		      (if (fix:>= s 0)
			  (begin (set! x (fix:+ x xinc))
				 (set! s (fix:+ s dxy)))
			  (set! s (fix:+ s dx2)))
		      (set! y (fix:+ y yinc))
		      (plot-if-in-picture x y picture value)
		      (loop (fix:+ i 1)))))))))
    (for-each (lambda (x)
		(draw-seg-in-picture picture (seg-start x) (seg-end x)))
	      segl)
    picture))


(define make-segment cons)

(define seg-start car)

(define seg-end cdr)

(define make-polygon list)

(define (2pt= pt1 pt2)
  (if  (and (= (round->exact (2d-pt-x pt1)) (round->exact (2d-pt-x pt2)))
	    (= (round->exact (2d-pt-y pt1)) (round->exact (2d-pt-y pt2))))
       true
       false))

(define (3pt= pt1 pt2)
  (if  (and (= (round->exact (3d-pt-x pt1)) (round->exact (3d-pt-x pt2)))
	    (= (round->exact (3d-pt-y pt1)) (round->exact (3d-pt-y pt2)))
	    (= (round->exact (3d-pt-z pt1)) (round->exact (3d-pt-z pt2))))
       true
       false))

(define (pt= pt1 pt2)
  (if (and (3d-pt? pt1)
	   (3d-pt? pt2))
      (3pt= pt1 pt2)
      (if (and (2d-pt? pt1)
	       (2d-pt? pt2))
	  (2pt= pt1 pt2)
	  false)))



