;;setup PS4

;;;set edwin window to 80 columns
;;;restore focus after drawing town

(define *graphics-window* false)
(define *geographic-data* false)
(define *census-data* false)
(define *boundary-segments* false)
(define *named-streets* false)
(define *graphics-save-region* false)

(define ps4-directory "/zu/u6001/fall92/psets/ps4")
(define ps4-data-directory "/sw/6001-databases/ps4-census-data")

;;;keep this list up to data as we add more towns

(define datasets-available
  '(("cambridge-somerville" "Cambridge and Somerville, Massachusetts")
    ("berkeley"             "Berkeley, California")
    ("hope"                 "Hope, Arkansas -- birthplace of Bill Clinton")
    ("palo-alto"            "Palo Alto and Stanford, California")
    ("bloomington"          "Bloomington, Indiana")
    ("lower-manhattan"      "Lower Manhattan, New York")
    ("boulder"              "Boulder, Colorado")
    ("texarkana"            "Texarkana, Texas -- birthplace of Ross Perot")
    ))

(define (setup)
  ;;make Edwin window narrower, to allow room for graphics window
  (in-package (->environment '(edwin x-commands))
    (using-syntax (access edwin-syntax-table (->environment '(edwin)))
      ((ref-command x-set-size) 80 65)))
  (with-working-directory-pathname
      ps4-directory
    (lambda ()
      (load "ps4-data-structures")
      (load "ps4-graphics")
      (load "ps4-selectors")
      (load "ps4-matcher")
      (load "ps4gram.scm")))
  )


(define (list-datasets)
  (newline)
  (display "The following datasets are available:")
  (newline)
  (for-each
   (lambda (entry)
     (newline)
     (write `(load-dataset ,(car entry)))
     (display " -- ")
     (display (cadr entry)))
   datasets-available
   ))


(define (load-dataset dataset-name)
  ;;clear out old data to make space
  (set! *geographic-data* false)
  (set! *named-streets* false)
  (set! *boundary-segments* false)
  (set! *census-data* false)
  (let ((data 
	 (with-working-directory-pathname
	     ps4-data-directory
	   (lambda () (fasload dataset-name)))))
    (set! *geographic-data* (dataset-geographic data))
    (set! *census-data* (dataset-census data))
    (initialize-graphics-window dataset-name)
    ))

(define (initialize-graphics-window dataset-name)
  ;;make the window 600x600
  (if *graphics-window* (graphics-close *graphics-window*))
  (if *graphics-save-region* (graphics-close *graphics-save-region*))
  (set! *graphics-window* (make-window 600 600 -5 +2))
  (graphics-operation *graphics-window* 'set-window-name
		      (string-append "Graphics: " dataset-name))
  (set! *graphics-save-region*
	(make-graphics-device x-graphics-device-type
			      false
			      (x-geometry-string -5 +2 600 600)
			      true))
  (graphics-operation *graphics-save-region* 'set-window-name
		      "If you can see this then there is a bug....")
  (initial-draw-town)
  )


(setup)
   

