(declare (usual-integrations))

#|
These are some selector functions for extracting information from
block groups.
|#

(define (shade-block b)
  (shade-blkgrp b "gray50"))

(define (shade-selected-blocks pred)
  (shade-selected-blocks-with-color
   pred
   (lambda (b) "grey50")))
		
(define (shade-all-blocks-with-color color-function)
  (shade-selected-blocks-with-color
   (lambda (b) true)
   color-function))


(define (shade-selected-blocks-with-color pred color-function)
  (draw-town)
  (for-each (lambda (block)
	      (if (pred block)
		  (let ((plot-color (color-function block)))
		    (shade-blkgrp block plot-color))))
	    *census-data*))

(define (average-house-value pop-data)
  (average-selected-data pop-data/house-value
			 average-house-value-per-category
			 pop-data))

(define (average-rent pop-data)
  (average-selected-data pop-data/rent
			 average-rent-per-category
			 pop-data))

(define (average-persons-per-unit pop-data)
  (average-selected-data pop-data/persons-per-unit
			 average-persons-per-unit-per-category
			 pop-data))

(define (average-age pop-data)
  (let ((age-records (record->data-list (pop-data/race-sex pop-data))))
    (let ((age-record-lists (map record->data-list age-records)))
      (let ((totals-in-each-category
	     ;;this next line is clever
	     (apply map (cons + age-record-lists))))
	(average-list-with-weights
	 totals-in-each-category
	 average-age-per-category)))))

;;a record is a vector with a header. So we convert to a vector and
;;strip off the header to get the data list

(define (record->data-list record)
  (cdr (vector->list record)))


(define (average-selected-data selector averages pop-data)
  (average-list-with-weights 
   (record->data-list (selector pop-data))
   averages))
	  
(define (average-list-with-weights data-list averages)
  (let ((total (apply + (map * data-list averages)))
	(total-num (apply + data-list)))
    (if (> total-num 0)
	(/ total total-num)
	0.)))


;;;fix so works when shade with white

(define (record-selector->color selector low high)
  (if (>= low high)
      (error "bad shading range" low high)
      (let ((range-scale (/ 100.0 (- high low))))
	(let ((value->color
	       (lambda (value)
		 (cond ((<= value low) "black")
		       ((>= value high) "white")
		       (else
			(string-append
			 "grey"
			 (number->string
			  (floor->exact (* (- value low) range-scale)))))))))
	  (lambda (block)
	    (value->color (selector block)))))))


(define (average-age->color low high)
  (record-selector->color average-age low high))

(define (average-rent->color low high)
  (record-selector->color average-rent low high))

(define (average-house-value->color low high)
  (record-selector->color average-house-value low high))

(define (average-persons-per-unit->color low high)
  (record-selector->color average-persons-per-unit low high))



;;;This runs through the record, summing the result of a function VALUE applied
;;;to selected fields of the record.
;;;The fields are selected by applying a predicate to an associated
;;;record-desc-list, which has an entry for each entry in the record

(define (sum-selected-record-field-values record record-desc-list predicate value)
    (apply +
	   (map (lambda (field desc)
		  (if (predicate desc)
		      (value field)
		      0))
		(record->data-list record)
		record-desc-list)))


(define (sum-selected-record-fields record record-desc-list predicate)
  (sum-selected-record-field-values record
				    record-desc-list
				    predicate
				    (lambda (x) x)))


#| Example:
(count-population
 block
 (lambda (race-sex-desc) (equal? (cadr race-sex-desc) 'female))
 (lambda (age-desc) (< age-desc 25)))

returns the total female population below age 25
|#

(define (count-population block race-sex-select age-select)
  (sum-selected-record-field-values
   (pop-data/race-sex block)
   race-sex-desc-list
   race-sex-select
   (lambda (race-sex)	;function to extract from race-sex record
     (sum-selected-record-fields
      race-sex
      age-desc-list
      age-select))))




