;;setup PS1

(define g1 false)
(define g2 false)
(define g3 false)

(define (setup)
  (setup-windows))

(define (setup-windows)
  ;;make the windows 257x257 to hold screens of size 256 (fencepost?)
  (if g1 (graphics-close g1))
  (if g2 (graphics-close g2))
  (if g3 (graphics-close g3))
  (set! g1 (make-window 257 257 -10 +10))
  (graphics-operation g1 'set-window-name "Graphics: g1")
  (set! g2 (make-window 257 257 -10 +320))
  (graphics-operation g2 'set-window-name "Graphics: g2")
  (set! g3 (make-window 257 257 -10 +630))
  (graphics-operation g3 'set-window-name "Graphics: g3")
  )

(define mixture
  (lambda (f p1 p2)
    (let ((grate (lambda (x y) (* .5 (+ 1 (sin (* f x)))))))
      (let ((grate-bar (lambda (x y) (- 1 (grate x y)))))
	(let ((grate-pic (procedure->picture 128 128 grate))
	      (grate-bar-pic (procedure->picture 128 128 grate-bar)))
	  (let ((mix1 (picture-map * grate-pic p1))
		(mix2 (picture-map * grate-bar-pic p2)))
	    (let ((double-mix (picture-map + mix1 mix2)))
	      double-mix)))))))


(setup)

