;;; This is the code for Problem Set 7 

(define print-stream
  (let ()
    (define (loop rest)
      (if (empty-stream? rest)
	  (princ '})
	  (sequence
	   (princ (head rest))
	   (princ " ")
	   (loop (tail rest)))))
    (lambda (s)
      (print '{)
      (loop s))))

(define (add-streams s1 s2)
  (cond ((empty-stream? s1) s2)
	((empty-stream? s2) s1)
	(else
	 (cons-stream (+ (head s1) (head s2))
		      (add-streams (tail s1) (tail s2))))))

(define (scale-stream constant s)
  (map (lambda (x) (* constant x)) s))

(define (filter pred s)
  (if (empty-stream? s)
      the-empty-stream
      (if (pred (head s))
	  (cons-stream (head s) (filter pred (tail s)))
	  (filter pred (tail s)))))

(define (map proc s)
  (if (empty-stream? s)
      the-empty-stream
      (cons-stream (proc (head s))
		   (map proc (tail s)))))

(define (random-bounded upper lower)
  (let ((x (random upper)))
    (if (< x lower)
	(random-bounded upper lower)
	x)))

(define (flip-a-coin)
 (= (random  2) 0))

(define (select-one-of-four)
  (random 4))

(define (get-patient-heart-signal)
  (make-signal (random-bounded 14 7) (random-bounded 100 10)))

(define (make-signal n noise-bound)
  (let ((interval (random-bounded 20 7))
	(speed-variation 0))
    (let ((tolerance (random-bounded interval 1))
	  (make-random (select-one-of-four)))
      (define (loop count)
	(let ((noise (/ (random noise-bound) 100)))
          (if (= make-random 0)
	      (if (not (= count interval))
		  (cond ((= (select-one-of-four) 0)
			 (set! count 0))
			((= (select-one-of-four) 1)
			 (set! count (+ 7 count))))))
	  (cond ((= count 0)
		 (cons-stream (if (flip-a-coin)
				  (- (+ n 1) noise)
				  (+ (+ n 1) noise))
			      (cond ((= interval 0)(loop interval))
				    (else
				     (set! interval (+ interval
						       speed-variation))
				     (loop interval)))))
		((= count tolerance)
		 (if (flip-a-coin)
		     (loop (- count 1))
		     (cons-stream (if (flip-a-coin)
				      (- 0 noise)
				      noise)
				  (loop (- count 1)))))
		(else
		 (cons-stream (if (flip-a-coin)
				  (- 0 noise)
				  noise)
			      (loop (- count 1)))))))
      (if (not (= make-random 0))
	  (cond ((> make-random 1)          ;;; speed up/slow down OR normal
		 (cond ((= make-random 2)
			(set! interval 7)      ;;; Speeding up
			(set! speed-variation (random-bounded 4 1)))
		       (else                   ;;; Slowing down
			(set! interval 21)
			(set! speed-variation (- (random-bounded 4 1))))))))
      (loop interval))))

(define (plot-stream s max-y num-vals)
  (define (sign x) (if (< x 0) -1 1))
  (define hp-screen-width 200)
  (define hp-screen-height 180)
  (define x-scale (* 2 (/ hp-screen-width num-vals)))
  (define y-scale (/ hp-screen-height max-y))
  (define (screen-x-point x)
    (round (- (* x x-scale)
	      hp-screen-width)))
  (define (screen-y-point y)
    (let ((intended-y (round (* y-scale y))))
      (if (> (abs intended-y) hp-screen-height)
	  (* (sign intended-y) hp-screen-height)
	  intended-y)))
  (define (iter s count)
    (if (> count num-vals)
	'done
	(sequence (draw-line-to (screen-x-point count)
				(screen-y-point (head s)))
		  (iter (tail s) (1+ count)))))
  (clear-graphics)
  (position-pen (screen-x-point 0)
		(screen-y-point (head s)))
  (iter (tail s) 1))

