;; This file is for the Adventure game.
;; It contains things that may have to be modified.

;; This file defines our imaginary world

;; Here is how we define people.

(define (make-person name place threshold)
  (let ((possessions '())
	(restlessness 0))
    
    (define (me m)
      (cond ((eq? m 'type) 'person)
	    ((eq? m 'name) name)
	    ((eq? m 'place) place)
	    ((eq? m 'look-around)
	     (forall (place 'things)
		     (lambda (thing)
		       (if (not (eq? me thing))
			   (print (thing 'name))))))

	    ((eq? m 'take)
	     (lambda (thing)
               (if (thing? thing)
                   (if (memq thing (place 'things))
                       (sequence
                        (newline)
                        (princ name)
                        (princ " took ")
                        (princ (thing 'name))
                        (set! possessions (cons thing possessions))
                        (forall (filter (place 'things) person?)
                                (lambda (p)
                                  (if (and (not (eq? p me))
                                           (memq thing (p 'possessions)))
                                      (sequence
                                       ((p 'lose) thing)
                                       (have-fit p)))))
                        ((thing 'change-possessor) me)
                        'taken)
                       (error "Thing taken not at this place"
                              (list (place 'name) thing)))
                   (error "Not a thing" thing))))

	    ((eq? m 'lose)
	     (lambda (thing)
	       (set! possessions (delete thing possessions))
	       ((thing 'change-possessor) 'no-one)
	       'lost))

	    ((eq? m 'list-possessions)
	     (forall possessions
		     (lambda (thing)
		       (print (thing 'name)))))

	    ((eq? m 'current-position)
	     (place 'name))

	    ((eq? m 'exits)
	     (place 'exits))

	    ((eq? m 'go)
	     (lambda (direction)
	       (let ((new-place ((place 'look-in) direction)))
		 (if (not (null? new-place))
		     (move-to new-place)
		     (sequence
		      (newline)
		      (princ "Can't go ")
		      (princ direction)
		      (princ " from ")
		      (princ (place 'name)))))))

	    ((eq? m 'possessions) possessions)

	    ((eq? m 'move)
	     (set! restlessness (1+ restlessness))
	     (if (> restlessness threshold)
		 (let ((new-place (random-place place)))
		   (if (not (null? new-place)) (move-to new-place)))))

	    ((eq? m 'go-to-heaven)
	     (forall possessions
		     (lambda(p) ((me 'lose) p)))
	     ((place 'gone) me)
	     ((heaven 'appear) me)
	     (set! place heaven)
	     'dead)

	    (else
	     (error "I don't know how to do this -- person"
		    (list name m)))))

    (define (move-to new-place)
      (announce-move name place new-place)
      (set! restlessness 0)
      (forall possessions
	      (lambda (p)
		((place 'gone) p)
		((new-place 'appear) p)))
      (let ((new-place-people
	     (filter (new-place 'things) person?)))
	(if (not (null? new-place-people))
	    (sequence
	     (newline)
	     (princ name)
	     (princ " says - Hi, ")
	     (forall new-place-people
		     (lambda(p)
		       (princ (p 'name))
		       (princ " "))))))
      ((place 'gone) me)
      ((new-place 'appear) me)
      (set! place new-place)
      nil)

    ((place 'appear) me)
    (enqueue me)
    me        ; return the dispatch procedure
    ))

;; Here we initialize the queue of people in our world and define
;; queue-manipulation procedures.

(define queue '())

(define (enqueue person)
  (set! queue (cons person queue))
  'enqueued)

(define (unqueue person)
  (set! queue (delete person queue))
  'dequeued)


;; Here we define the places in our world

(define Bldg-36 (make-place 'Bldg-36))
(define eric-office (make-place 'eric-office))
(define hal-office (make-place 'hal-office))
(define Tech-Square (make-place 'Tech-Square))
(define computer-lab (make-place 'computer-lab))
(define EGG-Atrium (make-place 'EGG-Atrium))
(define Bldg-10 (make-place 'Bldg-10))
(define dormitory (make-place 'dormitory))
(define heaven (make-place 'heaven))
(define dungeon (make-place 'dungeon))
(define dean-office (make-place 'dean-office))

;; One-way paths connect individual places in the world.

(define (can-go from direction to)
  ((from 'new-neighbor) direction to))

(can-go Bldg-36 'up computer-lab)
(can-go Bldg-36 'north Tech-Square)
(can-go Bldg-36 'west EGG-Atrium)
(can-go Tech-Square 'south Bldg-36)
(can-go Tech-Square 'up hal-office)
(can-go hal-office 'down Tech-Square)
(can-go hal-office 'up eric-office)
(can-go eric-office 'down hal-office)
(can-go computer-lab 'down Bldg-36)
(can-go dormitory 'east Bldg-10)
(can-go Bldg-10 'west dormitory)
(can-go Bldg-10 'north EGG-Atrium)
(can-go dungeon 'up EGG-Atrium)
(can-go EGG-Atrium 'south Bldg-10)
(can-go EGG-Atrium 'east Bldg-36)
(can-go dean-office 'west dormitory)
(can-go dean-office 'down Bldg-10)

;; We define persons as follows:

(define eric (make-person 'eric eric-office 1))
(define hal (make-person 'hal hal-office 2))

;;Here we define a TROLL and a DEAN

(define (make-troll name place threshold)
  (let ((hunger 0)
	(possessions '()))
    (define (me m)
      (cond ((eq? m 'type) 'troll)
	    ((eq? m 'name) name)
	    ((eq? m 'place) place)
	    ((eq? m 'possessions) possessions)
	    ((eq? m 'current-position)
	     (place 'name))
	    ((eq? m 'move)
	     (set! hunger (1+ hunger))
	     (if (> hunger threshold)
		 (if (not (null? (people-at-place place)))
		     (eat-person (people-at-place place))
		     (let ((new-place (random-place place)))
		       (if (not (null? new-place)) (move-to new-place))))))
	    (else
	     (error "I don't know how to do this -- troll" m))))

    (define (people-at-place place)
      (filter (place 'things) person?))

    (define (eat-person persons)
      (let ((selected-person
	     (nth (random (length persons)) persons)))
	nil
	))

    (define (move-to new-place)
      (announce-move name place new-place)
      ((place 'gone) me)
      ((new-place 'appear) me)
      (set! place new-place)
      (if (not (null? (people-at-place new-place)))
	  (eat-person (people-at-place new-place))))
    
    ((place 'appear) me)
    me    ; return the dispatch procedure
    ))


(define (make-dean place threshold)
  (let ((officiousness 0)
	(possessions '()))
    (define (me m)
      (cond ((eq? m 'type) 'person)
	    ((eq? m 'go-to-heaven)
	     ((place 'gone) me)
	     ((heaven 'appear) me)
	     (set! place heaven))
	    ((eq? m 'name) 'dean)
	    ((eq? m 'place) place)
	    ((eq? m 'possessions) possessions)
	    ((eq? m 'current-position)
	     (place 'name))
	    ((eq? m 'move)
	     (set! officiousness (1+ officiousness))
	     (if (> officiousness threshold)
		 (if (not (null? (beers-at-place place)))
		     (smash-beer place)
		     (let ((new-place (random-place place)))
		       (if (not (null? new-place)) (move-to new-place))))))
	    (else
	     (error "I don't know how to do this -- dean" m))))

    (define (beers-at-place place)

      '()

      )

    (define (smash-beer this-place)
      (print "DEAN says - Ah-HAH! Caught you!!")
      (print "I do not approve of beer on campus!")
      (print "DEAN smashes beer and returns to DEAN-OFFICE")
      (forall (beers-at-place this-place)
	      (lambda(b)
		(let ((owner (b 'possessor)))
		  ((owner 'lose) b)
		  (have-fit owner)
		  ((this-place 'gone) b))))
      (set! officiousness 0)
      ((this-place 'gone) me)
      ((dean-office 'appear) me)
      (set! place dean-office)
      'smashed)

    (define (move-to new-place)
      (announce-move 'DEAN place new-place)
      ((place 'gone) me)
      ((new-place 'appear) me)
      (set! place new-place)
      (if (not (null? (beers-at-place place)))
	  (smash-beer place)
	  'moved)
      )

    ((place 'appear) me)
    me     ; return the dispatch procedure
    ))
