(define (visit-doctor name)
  (print (append '(hello, ) (list name)))
  (print '(what seems to be the problem?))
  (doctor-driver-loop name))

(define (doctor-driver-loop name)
  (newline) (princ '**)
  (let ((user-response (read)))
    (cond ((equal? user-response '(goodbye))
	   (print (list 'goodbye,  name))
	   (print '(and a pleasant day to you)))
	  (else (print-reply user-response)
		(doctor-driver-loop name)))))

(define (print-reply user-response)
  (cond ((fifty-fifty)
	 (print (append (qualifier)
			(change-person user-response))))
	(else (print (hedge)))))

(define (qualifier)
  (pick-random '((you seem to think)
		 (you feel that)
		 (why do you believe)
		 (why do you say))))

(define (hedge)
  (pick-random '((please go on)
		 (many people have the same sorts of feelings)
		 (many of my patients have told me the same thing)
		 (please continue))))

(define (replace pattern replacement lst)
  (cond ((null? lst) '())
	((equal? (car lst) pattern)
	 (cons replacement
	       (replace pattern replacement (cdr lst))))
	(else (cons (car lst)
		    (replace pattern replacement (cdr lst))))))

(define (many-replace replacement-pairs lst)
  (cond ((null? replacement-pairs) lst)
	(else (replace (caar replacement-pairs)
		       (cadar replacement-pairs)
		       (many-replace (cdr replacement-pairs)
				     lst)))))

(define (change-person phrase)
  (many-replace '((i you) (me you) (my your) (am are) (myself yourself))
		phrase))

(define (pick-random lst)
  (nth (random (length lst)) lst))

(define (fifty-fifty) (pick-random '(t ())))
