;;;code for problem set 2 on testing for primality

(define (smallest-divisor n)
  (find-divisor n 2))

(define (find-divisor n test-divisor)
  (cond ((> (square test-divisor) n) n)
	((divides? test-divisor n) test-divisor)
	(else (find-divisor n (+ 1 test-divisor)))))


(define (divides? a b)
  (= (remainder b a) 0))

(define (prime? n)
  (= n (smallest-divisor n)))

(define (fermat-test n)
  (define a (+ 2 (big-random (- n 2))))
  (= (expmod a n n) a))

(define (fast-prime? n times)
  (cond ((= times 0) t)
        ((fermat-test n) (fast-prime? n (- times 1)))
        (else nil)))

(define (expmod b e m)
  (cond ((= e 1) b)
	((divides? 2 e)
	 (remainder (square (expmod b (quotient e 2) m))
		    m))
	(else
	 (remainder (* b (expmod b (- e 1) m))
		    m))))

(define (big-random n)
  (random (min n (expt 10 10))))

(define (square x) (* x x))

