'From Smalltalk-80, Version 2.2 of July 4, 1987 on 1 February 1989 at 6:35:34 pm'!

OrderedCollection variableSubclass: #Decoder
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Collections-Streams'!


!Decoder methodsFor: 'decoding'!

decodeValue: anObject
	| variableName |
	self do:
		[:dict | (variableName _ (dict keyAtValue: anObject ifAbsent: [nil])) notNil
			ifTrue:
				[^ variableName]].
	^ nil! !



WriteStream subclass: #DecodingStream
	instanceVariableNames: 'stream decoder '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Collections-Streams'!


!DecodingStream methodsFor: 'accessing'!

nextPut: anObject
	stream nextPut: anObject!

position
	^ stream position! !

!DecodingStream methodsFor: 'decoding'!

decoder: aDecoder
	decoder _ aDecoder!

decodeValue: anObject
	^ decoder decodeValue: anObject! !

!DecodingStream methodsFor: 'private'!

stream: aStream decoder: aDecoder
	stream _ aStream.
	decoder _ aDecoder! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

DecodingStream class
	instanceVariableNames: ''!


!DecodingStream class methodsFor: 'instance creation'!

stream: aStream decoder: aDecoder
	^ self basicNew stream: aStream decoder: aDecoder! !



!WriteStream methodsFor: 'copying'!

copyOnto: aStream
	aStream on: collection from: position + 1 to: self size! !

!WriteStream reorganize!
('accessing' contents next nextPut: size)
('positioning' position: reset)
('character writing' cr crtab crtab: emphasis emphasis: space tab)
('printing' print: store:)
('copying' copyOnto:)
('fileIn/Out' nextChunkPut:)
('private' on: on:from:to: pastEndPut: with:)
!



!Object methodsFor: 'printing'!

printOn: aStream 
	"Append to the argument aStream a sequence of characters that identifies the receiver."

	| title variableName |
	aStream class == DecodingStream ifTrue:
		[(variableName _ aStream decodeValue: self) notNil ifTrue:
			[^ aStream nextPutAll: variableName]].
	title _ self class name.
	aStream nextPutAll: ((title at: 1) isVowel
							ifTrue: ['an ']
							ifFalse: ['a '])
						, title!


printOn: aStream decoding: aDecoder
	"Append to the argument aStream a sequence of characters that identifies the receiver.  Where values can be found in the Decoder, decode them and write the appropriate variable name."

	self printOn: (DecodingStream stream: aStream decoder: aDecoder)!


storeOn: aStream 
	"Append to the argument aStream a sequence of characters that is an expression 
	whose evaluation creates an object similar to the receiver.  The general format
	for objects is
		(class-name basicNew 
			instVarAt: index put: variable;
			basicAt: index put: element;
			yourself)
	or
		((class-name basicNew: size )
			instVarAt: index put: variable;
			basicAt: index put: element;
			yourself) "

	| variableName |
	aStream class == DecodingStream ifTrue:
		[(variableName _ aStream decodeValue: self) notNil ifTrue:
			[^ aStream nextPutAll: variableName]].
	aStream nextPut: $(.
	self class isVariable
		ifTrue: [aStream nextPutAll: '(', self class name, ' basicNew: ';
					store: self basicSize;
					nextPutAll: ') ']
		ifFalse: [aStream nextPutAll: self class name, ' basicNew'].
	1 to: self class instSize do:
		[:i |
		aStream nextPutAll: ' instVarAt: ';
			store: i;
			nextPutAll: ' put: ';
			store: (self instVarAt: i);
			nextPut: $;].
	1 to: self basicSize do:
		[:i |
		aStream nextPutAll: ' basicAt: ';
			store: i;
			nextPutAll: ' put: ';
			store: (self basicAt: i);
			nextPut: $;].
	aStream nextPutAll: ' yourself)'!


storeOn: aStream decoding: aDecoder
	"Append to the argument aStream a sequence of characters that is an expression whose evaluation creates an object similar to the receiver.  Where values can be found in the Decoder, decode them and write the appropriate variable name."

	self storeOn: (DecodingStream stream: aStream decoder: aDecoder)! !
'From Smalltalk-80, Version 2.2 of July 4, 1987 on 6 September 1988 at 8:45:48 pm'!



!Object methodsFor: 'copying'!

dontCopyOnGrow
	^ #()! !


!Dictionary methodsFor: 'adding'!

dontCopyOnGrow
	^ super dontCopyOnGrow, #('tally')! !


!IdentityDictionary methodsFor: 'adding'!

dontCopyOnGrow
	^ super dontCopyOnGrow, #('valueArray')! !


!Object methodsFor: 'copying'!

copyInstVarsTo: aCopy except: exceptions
	"Give aCopy a shared reference to all instance variables of the receiver, excluding those in exception array.  This is used by objects with both named and indexed instance variables, when doing a 'grow'."

	| index allInstVars copyVars |
	allInstVars _ self class allInstVarNames.
	copyVars _ allInstVars select: [:instVar | (exceptions includes: instVar) not].
	copyVars do:
		[:copyVar | index _ allInstVars indexOf: copyVar.
		aCopy instVarAt: index put: (self instVarAt: index)].
	^ aCopy! !


!Dictionary methodsFor: 'adding'!

grow
	"Increase the number of elements of the collection."

	| newSelf |
	newSelf _ self species new: self basicSize + self growSize.
	self associationsDo: [:each | newSelf noCheckAdd: each].
	self copyInstVarsTo: newSelf except: self dontCopyOnGrow.
	self become: newSelf! !'From Smalltalk-80, Version 2.2 of July 4, 1987 on 15 March 1988 at 3:47:06 pm'!



!Browser methodsFor: 'class list'!

classList
	category == nil ifTrue: [^ nil].
	category = '**Hierarchy**' ifTrue:
		[^ ChangeSet hierarchicalOrder: self selectedClass withAllSuperclasses reverse,
										self selectedClass allSubclasses].
	^ ChangeSet hierarchicalOrder:
		((organization listAtCategoryNamed: category) collect: [:aClassName | Smalltalk at: aClassName])!


className: selection
	className _ selection isNil
		ifTrue: [nil]
		ifFalse: [(selection copyWithout: $ ) asSymbol].
	self newProtocolList: protocol.
	selection isNil & category notNil
		ifTrue: [self textMode: #classDefinition]
		ifFalse: [self classMode ifTrue: [self changed: #text]]!  !


!ChangeSet class methodsFor: 'fileIn/Out'!

hierarchicalOrder: classes 
	"Return an Array containing the names of the given classes, arranged in hierarchical order and indented (for displaying a Browser class list, etc)."

	| goalCollection |
	goalCollection _ OrderedCollection new.
	classes do:
		"Put in the 'top-level' classes, and for each of these, its subclasses."
		[:class | (classes includes: class superclass) ifFalse:
			[goalCollection addLast: class name.
			goalCollection addAllLast: (self orderSubclassesOf: class from: classes indent: 1)]].
	^ goalCollection asArray!


orderSubclassesOf: aClass from: classes indent: indent
	"Return a hierarchically ordered collection of the subclasses of aClass."

	| goalCollection |
	goalCollection _ OrderedCollection new.
	classes do:
		[:class | (class superclass == aClass) ifTrue:
			[goalCollection addLast: (String new: indent*2 withAll: $ ), class name.
			goalCollection addAllLast: (self orderSubclassesOf: class from: classes indent: indent+1)]].
	^ goalCollection! !


!SelectionInListView methodsFor: 'list access'!

list: anArray
	"Set my list to be anAray."

	| item theList index |
	itemList _ anArray.
	anArray == nil ifTrue:
		[isEmpty _ true.
		selection _ 0.
		^self changeModelSelection: 0].
	isEmpty _ false.
	printItems 
		ifTrue: [theList _ anArray collect:
					[:each | each printString copyUpTo: Character cr]]
		ifFalse: [theList _ anArray].
	list _ TextList onList:
		(topDelimiter == nil
			ifTrue: [theList]
			ifFalse: [(Array with: topDelimiter) ,
					theList ,
					(Array with: bottomDelimiter)]).
	item _ self initialSelection.
	selection _ item == nil
			ifTrue: [0]
			ifFalse:
				[index _ itemList findFirst: [:x | x = item].
				"If not found, and if items are symbols, try again removing identation."
				(index == 0 and: [item isKindOf: Symbol])
					ifTrue: [index _ itemList findFirst: [:x | (x copyWithout: $ ) asSymbol = item]].
				index].
	self positionList.
	self changeModelSelection: selection! !