MouseMenuController subclass: #DrawingController
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Simple Demos'!


!DrawingController methodsFor: 'figure deletion'!

delete: aFigure
| rectangle |
	rectangle _ aFigure displayBox.
			model remove: aFigure.
			aFigure colour: view backgroundColour.
			view display: rectangle!

deleteFigure
| point figure|
	point _ self localCursorPoint.
	figure _ model figureAt: point.
	figure isNil
		ifFalse: 
			[self delete: figure]! !

!DrawingController methodsFor: 'figure colouring'!

paintFigure
	| point figure colour rectangle |
	point _ self localCursorPoint.
	figure _ model figureAt: point.
	figure isNil
		ifFalse: 
			[colour _ FillInTheBlank request: 'What colour do you want ?'.
			figure colour: colour.
			rectangle _ figure displayBox.
			view display: rectangle]! !

!DrawingController methodsFor: 'control activity'!

changeColour
|aFigure aPoint|
aPoint _ self localCursorPoint.
aFigure _ model figureAt: aPoint.
aFigure isNil ifTrue: [nil] ifFalse: [self paintFigure: aFigure]!

controlActivity
sensor redButtonPressed ifTrue: [self moveOrCreate].
super controlActivity!

moveOrCreate
|aFigure aPoint|
aPoint _ self localCursorPoint.
aFigure _ model figureAt: aPoint.
aFigure isNil ifTrue: [self createFigureAt: aPoint] ifFalse: [self moveFigure: aFigure]! !

!DrawingController methodsFor: 'figure creation'!

createFigureAt: aPoint 
|aFigure|
aFigure _ Figure rectangle: (aPoint extent: 1@1).
model add: aFigure.
self growFigure: aFigure!

makeFigure: aRectangle 
|aFigure|
aFigure _ Figure rectangle: aRectangle.
model add: aFigure! !

!DrawingController methodsFor: 'figure animation'!

changing: aFigure track: aBlock
|oldPoint newPoint aRectangle|
oldPoint _ self localCursorPoint.
[sensor redButtonPressed] whileTrue: [(newPoint _ self localCursorPoint) ~= oldPoint ifTrue: [aRectangle _ aFigure displayBox.
aBlock value: newPoint - oldPoint.
aRectangle _ aRectangle merge: aFigure displayBox.
view display: aRectangle.
oldPoint _ newPoint]]!

moveFigure: aFigure
self changing: aFigure track: [:delta| aFigure moveBy: delta]! !

!DrawingController methodsFor: 'cursor control'!

localCursorPoint
^view inverseDisplayTransform: sensor cursorPoint! !

!DrawingController methodsFor: 'initialization'!

initialize
super initialize.
self yellowButtonMenu: (PopUpMenu labels: 'colour\rotate\delete' withCRs)
	yellowButtonMessages: #(paintFigure rotateFigure deleteFigure)! !

!DrawingController methodsFor: 'figure transforms'!

growFigure: aFigure
self changing: aFigure track: [:delta | aFigure growBy: delta]!

rotateFigure
| point figure rectangle newRectangle |
	point _ self localCursorPoint.
	figure _ model figureAt: point.
	figure isNil
		ifFalse: 
			[rectangle _ figure displayBox.
			newRectangle _ Rectangle origin: (rectangle center x - (rectangle height / 2) rounded) @ (rectangle center y - (rectangle width / 2) rounded) extent: rectangle extent. self delete: figure. self makeFigure: newRectangle.
			view display: newRectangle]! !

Object subclass: #Figure
	instanceVariableNames: 'rectangle colourMessage '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Simple Demos'!


!Figure methodsFor: 'display'!

displayBox 
^ rectangle!

displayOn: aDisplayMedium at: aPoint clippingBox: aRectangle
aDisplayMedium perform: (self colour
 asSymbol) with: ((self displayBox intersect: aRectangle) translateBy: aPoint)!

intersects: aRectangle
^self displayBox intersects: aRectangle! !

!Figure methodsFor: 'private'!

setRectangle: aRectangle
rectangle _ aRectangle! !

!Figure methodsFor: 'access'!

colour: aString
colourMessage _ aString append: ':'! !

!Figure methodsFor: 'query'!

colour
^colourMessage! !

!Figure methodsFor: 'selection'!

containsPoint: aPoint
^self displayBox containsPoint: aPoint! !

!Figure methodsFor: 'animation'!

moveBy: aPoint
rectangle _ rectangle translateBy: aPoint! !

!Figure methodsFor: 'transformation'!

growBy: aPoint
rectangle _ rectangle origin extent: rectangle extent + aPoint! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Figure class
	instanceVariableNames: ''!


!Figure class methodsFor: 'creation'!

rectangle: aRectangle
|candidate|
candidate _ self new.
candidate setRectangle: aRectangle.
candidate colour: 'lightGray'.
^ candidate! !

Object subclass: #ListExample
	instanceVariableNames: 'myList item '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Simple Demos'!


!ListExample methodsFor: 'scheduling'!

openListBrowser
|topView listView|
topView _ StandardSystemView new.
topView model: self; label: 'List View demo'; borderWidth: 1.
listView _ self buildListView.
listView borderWidth: 1.
topView addSubView: listView.
topView controller open! !

!ListExample methodsFor: 'menu messages'!

addItem
|sourceCode newItem|
sourceCode _ FillInTheBlank request: 'Enter a ST expression to generate this item:'.
sourceCode isEmpty ifFalse: [newItem _ Compiler evaluate: sourceCode.
self myList add: newItem. self item: newItem. self changed: #item]!

inspectItem
self item isNil ifFalse: [self item inspect]!

removeItem
self item isNil ifFalse: [self myList remove: self item. self item: nil. self changed: #item]! !

!ListExample methodsFor: 'viewing'!

buildListView
^ SelectionInListView on: self printItems: true oneItem: false aspect: #item change: #item: list: #getList menu: #listMenu initialSelection: nil!

getList
|list|
list _ self myList.
list isNil ifTrue: [^nil] ifFalse: [^ list asSortedCollection: [:first :second| first printString <= second printString]]!

listMenu
^ ActionMenu labels: 'add item\remove item\inspect item' withCRs lines: #(2) selectors: #(addItem removeItem inspectItem)! !

!ListExample methodsFor: 'accessing'!

item
^item!

item: anObject
item _ anObject!

myList
myList isNil ifTrue: [self myList: #() asOrderedCollection. self myList add: self].
^myList!

myList: aSequenceableCollection
myList _ aSequenceableCollection! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ListExample class
	instanceVariableNames: ''!


!ListExample class methodsFor: 'examples'!

example
"ListExample example"
self new openListBrowser! !

View subclass: #DrawingView
	instanceVariableNames: 'backgroundColour '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Simple Demos'!


!DrawingView methodsFor: 'private'!

computeDisplayTransformation
"override the relevant View method to prevent scaling (only translation is required to see more of a picture)"
^WindowingTransformation scale: nil translation: super computeDisplayTransformation translation rounded! !

!DrawingView methodsFor: 'display'!

display: aRectangle
|aForm|
aForm _ Form extent: aRectangle extent.
aForm fill: aForm computeBoundingBox rule: Form over mask: (Form perform: self backgroundColour asSymbol).
model displayOn: aForm at: aRectangle origin * -1 clippingBox: aRectangle.
aForm displayOn: Display at: self insetDisplayBox origin + aRectangle origin clippingBox: self insetDisplayBox!

displayView
self display: (self inverseDisplayTransform: self insetDisplayBox)! !

!DrawingView methodsFor: 'default controller'!

defaultControllerClass
^DrawingController! !

!DrawingView methodsFor: 'access'!

backgroundColour
^backgroundColour!

backgroundColour: aString
backgroundColour _ aString! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

DrawingView class
	instanceVariableNames: ''!


!DrawingView class methodsFor: 'creation'!

openOn: aDrawing
|topView subView|
subView _ self new model: aDrawing.
subView borderWidth: 0.
subView backgroundColour: 'white'.
subView insideColor: Form white.
subView controller: DrawingController new initialize.
topView _ StandardSystemView new.
topView borderWidth: 1; label: 'Micro Draw'.
topView addSubView: subView in: (0@0 extent: 1@1) borderWidth: 1.
topView controller open! !

Object subclass: #Drawing
	instanceVariableNames: 'figures '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Simple Demos'!


!Drawing methodsFor: 'display'!

displayOn: aDisplayMedium at: aPoint  clippingBox: aRectangle
(self figuresIntersecting: aRectangle) reverseDo: [:each| each displayOn: aDisplayMedium at: aPoint clippingBox: aRectangle]!

figuresIntersecting: aRectangle
^ figures select: [:each| each intersects: aRectangle]! !

!Drawing methodsFor: 'initialization'!

initialize
figures _ OrderedCollection new!

open
DrawingView openOn: self! !

!Drawing methodsFor: 'selection'!

figureAt: aPoint
^ figures detect: [:each | each containsPoint: aPoint] ifNone: [nil]! !

!Drawing methodsFor: 'access'!

add: aFigure
figures addFirst: aFigure!

remove: aFigure
figures remove: aFigure ifAbsent: [Transcript show: 'figure non-existent'; cr]! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Drawing class
	instanceVariableNames: ''!


!Drawing class methodsFor: 'creation'!

new
^super new initialize! !

Object variableSubclass: #Rope
	instanceVariableNames: ''
	classVariableNames: 'FacadeBlt OutlinerBlt '
	poolDictionaries: ''
	category: 'Simple Demos'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Rope class
	instanceVariableNames: ''!


!Rope class methodsFor: 'initialization'!

initialize
	| aForm |
	aForm _ Form
				extent: 24 @ 24
				fromArray: #(65535 65280 65535 65280 65519 65280 64949 65280 65326 65280 65315 32512 62978 57088 64517 65280 62473 24320 60932 65280 62775 32512 65449 57088 62647 32512 61397 65280 64863 65280 65531 32512 64439 65280 65503 65280 65535 65280 65535 65280 65535 65280 65535 65280 65535 65280 65535 65280 )
				offset: 0 @ 0.
	OutlinerBlt _ BitBlt destForm: Display sourceForm: (Form dotOfSize: aForm width) halftoneForm: nil combinationRule: Form under destOrigin: 0@0 sourceOrigin: 0@0 extent:  aForm extent clipRect: Display boundingBox.
	FacadeBlt _ BitBlt destForm: Display sourceForm: aForm halftoneForm: nil combinationRule: Form and destOrigin: 0@0 sourceOrigin: 0@0 extent: aForm extent clipRect: Display boundingBox! !

!Rope class methodsFor: 'display'!

displayOn: aDisplayMedium 
	| facadeStream outlinerStream |
	OutlinerBlt destForm: aDisplayMedium.
	FacadeBlt destForm: aDisplayMedium.
	facadeStream _ ReadStream on: self.
	outlinerStream _ ReadStream on: self.
	6 timesRepeat: [OutlinerBlt destOrigin: outlinerStream next; copyBits]. [outlinerStream atEnd] whileFalse: [OutlinerBlt destOrigin: outlinerStream next; copyBits. FacadeBlt destOrigin: facadeStream next; copyBits].
	6 timesRepeat: [FacadeBlt destOrigin: facadeStream next; copyBits]! !

Rope initialize!
