Object subclass: #Player
	instanceVariableNames: 'dice score name opponent tasks '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'CugelsWorld'!


!Player methodsFor: 'actions'!

roll
|eyes|
Transcript show: name; show: ' rolls '.
eyes _ dice next.
score _ score + eyes.
Transcript show: eyes printString; show:'. His score is now '; show: score printString; cr.
self won ifTrue: [self win]!

startPlayWith: aPlayer
self setOpponent: aPlayer.
tasks resume!

win
Transcript show: self name, ' wins !!!! Bad luck ', self opponent name, ' !!!!'; cr.
opponent tasks terminate.
self tasks terminate! !

!Player methodsFor: 'queries'!

name
^ name!

opponent
^ opponent!

score
^ score!

tasks
^ tasks!

won
(self score >= 9) ifTrue: [^true] ifFalse: [^false]! !

!Player methodsFor: 'initialization'!

giveName: aName
name _ aName!

initialize 
score _ 0.
dice _ RandInt from: 1 to: 6!

setOpponent: aPlayer
opponent _ aPlayer!

setTasks
tasks _ [[opponent won not] whileTrue: [self roll. Processor yield]] newProcess.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

Player class
	instanceVariableNames: ''!


!Player class methodsFor: 'creation'!

newPlayer: aName
|fred|
fred _ Player new.
fred giveName: aName.
fred initialize.
^ fred! !

Object subclass: #RandomGenerator
	instanceVariableNames: 'lastNumber a m seed '
	classVariableNames: 'SeedIndex Seeds '
	poolDictionaries: ''
	category: 'CugelsWorld'!


!RandomGenerator methodsFor: 'sampling'!

nextRN
"a multiplicative congruential method (returning a uniform 0,1 rn)"
|rn|
rn _ (lastNumber * a) rem: m.
lastNumber _ rn.
^ (rn / m) asFloat! !

!RandomGenerator methodsFor: 'queries'!

a
^a!

lastNumber
^lastNumber!

m
^m!

seed
^seed! !

!RandomGenerator methodsFor: 'reset'!

reset
self initialize! !

!RandomGenerator methodsFor: 'initialization'!

a: anInteger
a _ anInteger!

askForParameters
self setSeed: (FillInTheBlank request: 'What seed value ?') asNumber.!

initialize
self a: 630360016.
lastNumber _ seed.
self m: 4294967295. "2^32 - 1"!

m: anInteger
m _ anInteger!

setSeed: anInteger
seed _ anInteger! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

RandomGenerator class
	instanceVariableNames: ''!


!RandomGenerator class methodsFor: 'queries'!

SeedIndex
^SeedIndex!

Seeds
^Seeds! !

!RandomGenerator class methodsFor: 'initialization'!

SetSeedArray
self Seeds: #(524287 12345 67891 23457 89123 45679 13793 24689 46813 68247)! !

!RandomGenerator class methodsFor: 'access'!

IncrementSeedIndex
SeedIndex >= 10 ifTrue: [self ResetSeedIndex] ifFalse: [SeedIndex _ SeedIndex + 1]!

ResetSeedIndex
SeedIndex _ 1!

SeedIndex: aPosInteger
SeedIndex _ aPosInteger!

Seeds: anArrayOfOddIntegers
Seeds _ anArrayOfOddIntegers! !

!RandomGenerator class methodsFor: 'creation'!

new
|candidate|
candidate _ super new.
self SetSeedArray.
(SeedIndex = nil) ifTrue: [self ResetSeedIndex] ifFalse: [ self IncrementSeedIndex]. 
candidate setSeed: (Seeds at: SeedIndex).
candidate initialize.
^candidate!

newWith: anInteger
|candidate|
candidate _ super new.
candidate setSeed: anInteger.
candidate initialize.
^candidate! !

Object subclass: #Distribution
	instanceVariableNames: 'generator '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'CugelsWorld'!


!Distribution methodsFor: 'access'!

generator: aRNgenerator 
	generator _ aRNgenerator! !

!Distribution methodsFor: 'query'!

generator
	^generator! !

!Distribution methodsFor: 'initialization'!

initialize
self generator: (RandomGenerator new).! !

!Distribution methodsFor: 'sampling'!

sample
self subclassResponsibility! !

Distribution subclass: #RandInt
	instanceVariableNames: 'lower upper range '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'CugelsWorld'!


!RandInt methodsFor: 'query'!

lower
	^lower!

range
	^range!

upper
	^upper! !

!RandInt methodsFor: 'initialization'!

lowerBound: aNumber 
	lower _ aNumber.
	upper isNil ifTrue: [upper _ 0].
	range _ upper - lower!

range: aNumber 
	range _ aNumber!

upperBound: aNumber 
	upper _ aNumber.
	lower isNil ifTrue: [lower _ 0].
	range _ upper - lower! !

!RandInt methodsFor: 'sampling'!

next
	| randomValue sampleValue |
	randomValue _ generator nextRN.
	sampleValue _ (lower + (randomValue * range)) rounded.
	^sampleValue! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

RandInt class
	instanceVariableNames: ''!


!RandInt class methodsFor: 'creation'!

from: aLowerBound to: anUpperBound 
	| candidate |
	candidate _ RandInt new.
	candidate lowerBound: aLowerBound; upperBound: anUpperBound.
	candidate range: anUpperBound - aLowerBound.
	candidate initialize.
	^candidate! !