; simple test of minimax game playing routines
; states are just lists of integers as follows
;
;	                                    (1)
;                                      |
;             +------------------------+-------------------------+
;             |                        |                         |
;          (1 1)                     (2 1)                     (3 1)
;    +-------+-------+         +-------+-------+         +-------+-------+
;    |       |       |         |       |       |         |       |       |
; (1 1 1) (2 1 1) (3 1 1)   (1 2 1) (2 2 1) (3 2 1)   (1 3 1) (2 3 1) (3 3 1)
;

! (define *addElem
    (lambda (n)
      ; return a function that adds n to front of list supplied as parameter
      (lambda (aState)
        (cons n aState))))
  
! (define MMGameProblem
    (MakeGameProblem '(1)
                     (lambda (aState machineMove?)
                       ; no special positions
                       #f)
                     (lambda (aState machineMove?)
                       ; return head of list as value
                       (car aState))
                     (MakeActionList (*addElem 1)
                                     (*addElem 2)
                                     (*addElem 3))
                     (MakeActionList (*addElem 1)
                                     (*addElem 2)
                                     (*addElem 3))))
  
= (FindBestMachineMove '(1) MMGameProblem #f 1)
  (3 (3 1))
= (GetCount MMGameProblem)
  3

= (FindBestMachineMove '(1) MMGameProblem #f 2)
  (1 (3 1)
     (2 1)
     (1 1))
= (GetCount MMGameProblem)
  12
  
= (FindBestMachineMove '(1) MMGameProblem #f 3)
  (3  (3 1)
      (2 1)
      (1 1))
= (GetCount MMGameProblem)
  39
