; test of Breadth First Search method
;
; simple test involving initial state (1 1 1) and each state can generate
; three new states with each possible value incremented.
; E.g. (1 1 1) can generate new states (2 1 1), (1 2 1) and (1 1 2)
;
! (define inc1
    (lambda (aState)
      (cons (+ 1 (car aState))
            (cdr aState))))
  
! (define inc2
    (lambda (aState)
      (cons (car aState)
            (cons (+ 1 (cadr aState))
                  (cddr aState)))))
  
! (define inc3
    (lambda (aState)
      (cons (car aState)
            (cons (cadr aState)
                  (cons (+ 1 (caddr aState))
                        (cdddr aState))))))

! (define BFProblem (MakeSearchProblem '(1 1 1)
                                       (lambda (aState) (equal? aState '(3 2 1))) ; goal function
                                       #f ; eval function
                                       (list inc1 inc2 inc3)))

; this should succeed
= (BFSearch BFProblem)
  (4 42 (#(ok NEG-INFINITY (3 2 1))
         #(ok NEG-INFINITY (3 1 1))
         #(ok NEG-INFINITY (2 1 1))
         #(ok NEG-INFINITY (1 1 1))))
  
! (define BFProblem (MakeSearchProblem '(1 1 1)
                                       (lambda (aState) (equal? aState '(1 2 3))) ; goal function
                                       #f ; eval function
                                       (list inc1 inc2 inc3)))

; this should succeed
= (BFSearch BFProblem)
  (4 90 (#(ok NEG-INFINITY (1 2 3))
         #(ok NEG-INFINITY (1 2 2))
         #(ok NEG-INFINITY (1 2 1))
         #(ok NEG-INFINITY (1 1 1))))
  