; tests on ATN toolbox

; TESTS
; -----

= (CheckTest? #t #f)
  #t
  
= (CheckTest? (lambda (regBank) #t) #f)
  #t

= (CheckTest? (lambda (regBank) #f) #f)
  #f
  
* (CheckTest? #f #f)

; REGISTERS
; ---------

= (MakeRegisterBank)
  ()

! (define *rbank* (SetRegister (MakeRegisterBank) 'verb 'go))

= *rbank*
  ((verb go))

! (set! *rbank* (SetRegister *rbank* 'noun 'horse))

= *rbank*
  ((noun horse) (verb go))

= (GetRegister *rbank* 'verb)
  go

* (GetRegister *rbank* 'article)

! (set! *rbank* (SetRegister *rbank* 'verb 'run))
  
= *rbank*
  ((verb run) (noun horse))
  
! (set! *rbank* (SetRegister *rbank* '** 'the))

= *rbank*
  ((** the) (verb run) (noun horse))
  
= (UpdateRegisters (list (SETR 'article **) (SETR 'lastverb (GETR 'verb)))
                   *rbank*)
  ((lastverb run) (article the) (** the) (verb run) (noun horse))

; FORMS
; -----
    
= (GETR 'verb)
  (GETR verb)

= (GETR? (GETR 'noun))
  #t

= (GetFormRegister (GETR 'verb))
  verb
  
= **
  **

= (**? **)
  #t

= (EvalForm (GETR 'verb)
            '((noun horse) (verb go)))
  go

= (EvalForm **
            '((noun horse) (verb go) (** the)))
  the


; ACTIONS
; -------
    
= (SETR 'noun **)
  (SETR noun **)

= (SETR? (SETR 'noun **))
  #t
 
= (SETR? (TO 'G1))
  #f
  
= (GetActionRegister (SETR 'noun **))
  noun

= (GetActionForm (SETR 'noun **))
  **
 
= (TO 'G1)
  (TO G1)

= (TO? (TO 'G1))
  #t

= (TO? (SETR 'noun **))
  #f
  
* (CheckActions ())

* (CheckActions (list (SETR 'noun **) (TO 'G1) (SETR 'verb **)))

= (CheckActions (list (SETR 'noun **) (TO 'G1)))
  ( ((SETR noun **)) (TO G1) )

= (ActionType (SETR 'noun **))
  SETR
  
; ARCS
; ----

! (define verbs (MakeCategory 'go 'jump 'run))

= verbs
  (go jump run)

= (CAT verbs #t (SETR 'verb **) (TO 'G1))
  (CAT (go jump run) #t ((SETR verb **)) (TO G1))

= (CAT? (CAT verbs #t (TO 'G1)))
  #t

= (CAT? (PUSH verbs #t (TO 'G1)))
  #f

= (GetCategory (CAT verbs #t (SETR 'verb **) (TO 'G1)))
  (go jump run)

= (InCategory? 'go (GetCategory (CAT verbs #t (SETR 'verb **) (TO 'G1))))
  #t

= (InCategory? 'horse (GetCategory (CAT verbs #t (SETR 'verb **) (TO 'G1))))
  #f

= (ANY #t (SETR 'thing **) (TO 'G1))
  (ANY #t ((SETR thing **)) (TO G1))

= (ANY? (ANY #t (SETR 'thing **) (TO 'G1)))
  #t

= (ANY? (PUSH verbs #t (TO 'G1)))
  #f

! (define *atn* (MakeATN))

* (GetCategory (PUSH *atn* #t (SETR 'verb **) (TO 'G1)))

= *atn*
  ()

= (PUSH *atn* #t (SETR 'verb **) (TO 'G1))
  (PUSH () #t ((SETR verb **)) (TO G1))

= (PUSH? (PUSH *atn* #t (TO 'G1)))
  #t

= (PUSH? (CAT verbs #t (TO 'G1)))
  #f
  
= (GetATN (PUSH *atn* #t (SETR 'verb **) (TO 'G1)))
  ()

* (GetATN (CAT verbs #t (SETR 'verb **) (TO 'G1)))

= (POP ** #t)
  (POP ** #t)

= (POP? (POP ** #t))
  #t

= (POP? (CAT verbs #t (TO 'G1)))
  #f
  
= (GetForm (POP ** #t))
  **

* (GetForm (CAT verbs #t (TO 'G1)))
  
= (GetTest (CAT verbs #t (TO 'G1)))
  #t

= (GetTest (ANY #t (SETR 'thing **) (TO 'G1)))
  #t

= (GetArcActions (PUSH *atn* #t (SETR 'verb **) (TO 'G1)))
  ((SETR verb **))

= (GetArcActions (ANY #t (SETR 'thing **) (TO 'G1)))
  ((SETR thing **))

= (GetNextState (PUSH *atn* #t (SETR 'verb **) (TO 'G1)))
  G1

= (ArcType (CAT verbs #t (TO 'G1)))
  CAT

; STATES
; ------
  
! (define *g1* (STATE 'G1 (CAT verbs #t (TO 'G2))
                              (POP ** #t)))

= *g1*
  (G1 (CAT (go jump run) #t () (TO G2))
      (POP ** #t))

= (GetStateLabel *g1*)
  G1

= (GetArcs *g1*)
  ((CAT (go jump run) #t () (TO G2)) (POP ** #t))

; ATNs
; ----
  
! (define *atn1* (MakeATN *g1*))
  
= *atn1*
  ((G1 (CAT (go jump run) #t () (TO G2)) (POP ** #t)))

! (define *g2* (STATE 'G2 (CAT verbs #t (TO 'G1))
                              (POP ** #t)))

! (define *atn2* (AddState *atn1* *g2*))
  
= *atn2*
  ((G1 (CAT (go jump run) #t () (TO G2)) (POP ** #t))
   (G2 (CAT (go jump run) #t () (TO G1)) (POP ** #t)))

= (InitialState *atn2*)
  (G1 (CAT (go jump run) #t () (TO G2)) (POP ** #t))
  
= (FindState *atn2* 'G1)
  (G1 (CAT (go jump run) #t () (TO G2)) (POP ** #t))

= (FindState *atn2* 'G2)
  (G2 (CAT (go jump run) #t () (TO G1)) (POP ** #t))

= (FindState *atn2* 'G3)
  ()

! (define *NP*
    (MakeATN
     (STATE 'NP1 (CAT '(the a) #t (TO 'NP2)))
     (STATE 'NP2 (CAT '(big green little) #t (TO 'NP2))
                 (CAT '(pig dog cat) #t (TO 'NP3)))
     (STATE 'NP3 (POP (lambda (dummy) 'success) #t))))

= (ParseAux *NP* (InitialState *NP*) (MakeRegisterBank)
                                     '(the green little pig)
                                     #f)
  (() ((** success)))

! (define *ADJ*
    (MakeATN
     (STATE 'A1 (CAT '(big green little) #t (TO 'A2)))
     (STATE 'A2 (POP (lambda (dummy) 'adjectives) #t))))

! (define *NAP*
    (MakeATN
     (STATE 'NP1 (CAT '(the a) #t (TO 'NP2)))
     (STATE 'NP2 (PUSH *ADJ* #t (TO 'NP2))
                 (CAT '(pig dog cat) #t (TO 'NP3)))
     (STATE 'NP3 (POP (lambda (dummy) 'sentence) #t))))


= (ParseAux *NAP* (InitialState *NAP*) (MakeRegisterBank)
                                       '(the green little pig)
                                       #f)
  (() ((** sentence)))

= (Parse *NAP* '(the green little pig))
  ((** sentence))
  
= (Parse *NAP* '(the green little pig) #f)
  ((** sentence))
  

; tests from section 3.7.2 of book

! (define article (MakeCategory 'a 'the))
  
! (define adjective
    (MakeCategory 'quick 'brown 'slow 'lazy))
  
! (define verb    (MakeCategory 'jumps 'runs))
      
! (define noun    (MakeCategory 'fox 'dog))
        
! (define notLast?
    (lambda (aRegisterBank)
      (not (equal? (GetRegister aRegisterBank 'adj)
                   (GetRegister aRegisterBank '**)))))
  
! (define differentNP?
    (lambda (aRegisterBank)
      (not (equal? (GetRegister aRegisterBank 'np)
                   (GetRegister aRegisterBank 'np1)))))

! (define addToEnd
    (lambda (aRegisterBank)
      (append (GetRegister aRegisterBank 'np)
              (list (GetRegister aRegisterBank '**)))))
  
! (define NP
    (MakeATN
     (STATE 'N1 (CAT article #t (SETR 'np ())
                                (SETR 'adj ())
                                (SETR 'np addToEnd)
                                (TO 'N2)))
     (STATE 'N2 (CAT adjective notLast?
                               (SETR 'np addToEnd)
                               (SETR 'adj **)
                               (TO 'N2))
                (CAT noun #t    (SETR 'np addToEnd)
                                (TO 'N3)))
     (STATE 'N3 (POP            (GETR 'np) #t))))
  
! (define SentenceATN
    (MakeATN
     (STATE 'S1 (PUSH NP  #t (SETR 'np1 **)
                             (TO 'S2)))
     (STATE 'S2 (CAT verb #t (SETR 'verb **)
                             (TO 'S3)))
     (STATE 'S3 (PUSH NP  #t (TO 'S4)))
     (STATE 'S4 (POP #t differentNP?))))
  
= (Parse SentenceATN
         '(a quick brown fox jumps a lazy dog))
  ((** #t)
   (np (a lazy dog))
   (adj lazy)
   (verb jumps)
   (np1 (a quick brown fox)))
  
= (Parse SentenceATN
         '(a quick quick fox jumps a lazy dog))
  #f

= (Parse SentenceATN
         '(a quick brown fox jumps a quick brown fox))
  #f
