; test of Cannibals microworld
;

! (SetUpMC)
! (define *g (GetGoalFN MC-SearchProblem))

= (*g '( (b c c c m m m) () ))
  #f

= (*g '( () (b c c c m m m) ))
  #t

! (define *e (GetEvalFN MC-SearchProblem))

= (*e '( (b c c c m m m) () ))
  -6

= (*e '( () (b c c c m m m) ))
  +6

! (define *movec (FirstAction (GetActions MC-SearchProblem)))

= (*movec '( (b c c c m m m) () ))
  ( (c c m m m) (b c) )

; next gives #f as missionaries get eaten
= (*movec '( (b c c m m) (c m) ))
  #f

= (DFSearch MC-SearchProblem 2)
  #f

= (DFSearch MC-SearchProblem 12)
  (12 65 (#(ok NEG-INFINITY (() (b c c c m m m)))
          #(ok NEG-INFINITY ((b c c) (c m m m)))
          #(ok NEG-INFINITY ((c) (b c c m m m)))
          #(ok NEG-INFINITY ((b c c c) (m m m)))
          #(ok NEG-INFINITY ((c c) (b m m m c)))
          #(ok NEG-INFINITY ((b c m c m) (m c)))
          #(ok NEG-INFINITY ((c m) (b m m c c)))
          #(ok NEG-INFINITY ((b c m m m) (c c)))
          #(ok NEG-INFINITY ((m m m) (b c c c)))
          #(ok NEG-INFINITY ((b c m m m c) (c)))
          #(ok NEG-INFINITY ((m m m c) (b c c)))
          #(ok NEG-INFINITY ((m m m c c c b)()))))
  
= (BFSearch MC-SearchProblem)
  (12 130 (#(ok NEG-INFINITY (() (b c c c m m m)))
           #(ok NEG-INFINITY ((b c c) (c m m m)))
           #(ok NEG-INFINITY ((c) (b c c m m m)))
           #(ok NEG-INFINITY ((b c c c) (m m m)))
           #(ok NEG-INFINITY ((c c) (b m m m c)))
           #(ok NEG-INFINITY ((b c m c m) (m c)))
           #(ok NEG-INFINITY ((c m) (b m m c c)))
           #(ok NEG-INFINITY ((b c m m m) (c c)))
           #(ok NEG-INFINITY ((m m m) (b c c c)))
           #(ok NEG-INFINITY ((b c m m m c) (c)))
           #(ok NEG-INFINITY ((m m m c) (b c c)))
           #(ok NEG-INFINITY ((m m m c c c b) ()))))
  
; All hill searches fail as it is necessary to walk back downhill
; (in the sence of moving people and the boat back to the left bank)
; to reach a solution

= (HillSearch MC-SearchProblem 2)
  #f

= (HillSearch MC-SearchProblem 12)
  #f

= (HillSearch MC-SearchProblem 15)
  #f

= (SteepestSearch MC-SearchProblem)
  (12 55 (#(ok 6 (() (b c m c c m m)))
          #(ok 2 ((b m c) (c c m m)))
          #(ok 4 ((c) (b c c m m m)))
          #(ok 0 ((b c c c) (m m m)))
          #(ok 2 ((c c) (b m m m c)))
          #(ok -2 ((b c m c m) (m c)))
          #(ok 2 ((c m) (b m m c c)))
          #(ok -2 ((b c m m m) (c c)))
          #(ok 0 ((m m m) (b c c c)))
          #(ok -4 ((b m m m c c) (c)))
          #(ok -2 ((m m c c) (b c m)))
          #(ok -6 ((m m m c c c b) ()))))
  