; Section 3.4.3: Monkey & Bannana problem

; To introduce a measure of 'control' into the monkey the Working
; Memory (WM) will contain a fact giving its current 'goal', which
; will move among the following states:
;  (goal eat)      eat the bannanas
;  (goal climb)    climb onto the box
;  (goal move)     move the box to the position of the banannas
;  (goal find)     move to the position of the box in the room
; Other facts in the WM will give the positions of the objects
; monkey, box and bannanas:
; (object at position) with  object = monkey, box, bannanas
;                        and position = door, middle, window
;  and whether the monkey is on the box or the floor:
;  (monkey on box)
;  (monkey on floor);

(define *MonkeyWM* (MakeWM '(monkey at door)
                           '(bannanas at middle)
                           '(box at window)
                           '(monkey on floor)))

(define x<>y?
  ; return #t if x and y are bound to different values
  (lambda (anAList)
    (not (equal? (GetAssociationValue 'x anAList)
		 (GetAssociationValue 'y anAList)))))

(define *MonkeyPM*
  (MakePM
   
   ; #1. If monkey has no goal then start with eating.
   (RULE "1-GiveGoal" 
         (CONDITIONS (~ (PATTERN 'goal ?)))
         (CONCLUSIONS (ASSERT '(goal eat))))
   
   ; #2. If the goal is to eat, and the monkey is on the box, 
   ;      then eat the bananas and leave
   (RULE "2-Eat" 
         (CONDITIONS '(goal eat)
                     '(monkey on box))
         (CONCLUSIONS 
          (EXECUTE 
           DisplayLine "Eating bannana...delicious!")
          (RETURN 
           (lambda(aWM) "Hunger satisfied"))))
   
   ; #3. If the goal is to eat, but the monkey is not on the box ,
   ;      then change the goal to climb
   (RULE "3-Eat" 
         (CONDITIONS '(goal eat)
                     '(monkey on floor))
         (CONCLUSIONS (RETRACT '(goal eat))
                      (ASSERT  '(goal climb))))
   
   ; #4. If the goal is climb ,and the monkey is on the box,
   ;     then change the goal to eat
   (RULE "4-Climb" 
         (CONDITIONS '(goal climb)
                     '(monkey on box))
         (CONCLUSIONS (RETRACT '(goal climb))
                      (ASSERT  '(goal eat))))
   
   ; #5. If the goal is climb, and the monkey is on the floor with the box 
   ;      under the bananas, then climb the box
   (RULE "5-Climb" 
         (CONDITIONS '(goal climb)
                     '(monkey on floor)
                     (PATTERN 'monkey   'at (? 'x))
                     (PATTERN 'box      'at (<-? 'x))
                     (PATTERN 'bannanas 'at (<-? 'x)))
         (CONCLUSIONS (RETRACT '(monkey on floor)) 
                      ; climb box
                      (ASSERT  '(monkey on box))))
   
   ; #6. If the goal is climb ,but the box is not under the bananas,
   ;      then change the goal to move
   (RULE "6-Climb" 
         (CONDITIONS '(goal climb)
                     '(monkey on floor)
                     (PATTERN 'box      'at (? 'x))
                     ; box and bananas must be in different places
                     (PATTERN 'bannanas 'at (? 'y x<>y?)))
         (CONCLUSIONS (RETRACT '(goal climb))
                      (ASSERT  '(goal move))))
   
   ; #7. If the goal is move and the monkey and box are under the bananas,
   ;      then change the goal to climb
   (RULE "7-Move"
         (CONDITIONS '(goal move)
                     (PATTERN 'monkey   'at (? 'x))
                     (PATTERN 'box      'at (<-? 'x))
                     (PATTERN 'bannanas 'at (<-? 'x)))
         (CONCLUSIONS (RETRACT '(goal move))
                      (ASSERT  '(goal climb))))
   
   ; #8. If the goal is move, and the monkey is with the box, but not under the
   ;     bananas, then push the box to under the bannanas
   (RULE "8-Move" 
         (CONDITIONS '(goal move)
                     (PATTERN 'monkey   'at (? 'x))
                     (PATTERN 'box      'at (<-? 'x))
                     (PATTERN 'bannanas 'at (? 'y x<>y?)))
         (CONCLUSIONS (RETRACT  ; move box
                       (PATTERN 'box 'at (<-? 'x)))
                      (ASSERT (PATTERN 'box 'at (<-? 'y)))
                      (RETRACT ; and also move monkey
                       (PATTERN 'monkey        'at (<-? 'x)))
                      (ASSERT (PATTERN 'monkey 'at (<-? 'y)))))
   
   ; #9. If the goal is move, and the monkey is not with the box ,
   ;     then change the goal to find
   (RULE "9-Move" 
         (CONDITIONS '(goal move)
                     (PATTERN 'monkey   'at (? 'x))
                     (PATTERN 'box      'at (? 'y x<>y?)))
         (CONCLUSIONS (RETRACT '(goal move))
                      (ASSERT  '(goal find))))
   
   ; #10. If the goal is find ,and the monkey is with the box,  
   ;      then change the goal to move
   (RULE "10-Find" 
         (CONDITIONS '(goal find)
                     (PATTERN 'monkey 'at (? 'x))
                     (PATTERN 'box    'at (<-? 'x)))
         (CONCLUSIONS (RETRACT '(goal find))
                      (ASSERT  '(goal move))))
   
   ; #11. If the goal is find, and the monkey is not with the box ,
   ;      then move the monkey to the box
   (RULE "11-Find" 
         (CONDITIONS '(goal find)
                     (PATTERN 'monkey 'at (? 'x))
                     (PATTERN 'box    'at (? 'y x<>y?)))
         (CONCLUSIONS (RETRACT ; move the monkey
                       (PATTERN 'monkey 'at (<-? 'x)))
                      (ASSERT
                       (PATTERN 'monkey 'at (<-? 'y)))))))

(define SolveMonkey
  (lambda ()
    (let 
      ((result (ForwardChainer *MonkeyPM* *MonkeyWM* #t)))
      (if (equal? result "Hunger satisfied")
          #f
          (DisplayLine "Monkey is still hungry")))))

(DisplayLine
 "Type (SolveMonkey) to solve the Monkey & Bannanas problem")
