
% OL(P): Object Layer for Prolog -- system objects (built-ins)
% Version 1.1 for SICStus Prolog and QUINTUS Prolog
% (C) 1993 Markus P.J. Fromherz.  All Rights Reserved.
% (C) 1993 Xerox Corporation.     All Rights Reserved.


% root object object

object (object).

   :- publish super/1, val/2.

   % super(?Object) -- true if Object is a superobject of self
   super(S) :-
      ol_super(self, S).

   % val(+Attribute, ?Value) -- true if Value is the value of Attribute of self
   val(A, V) :-
      .A = V.

end_object (object).


% information object ol

object ol.

   :- publish (object)/1, super/2, sub/2.

   % object(?Object) -- true if Object is an object name
   object(O) :-
      ol_object(O, _, _).

   % super(?Object, ?Super) -- true if Super is a superobject of Object
   super(O, S) :-
      ol_object(O, _, _),
      ol_super(O, S).

   % sub(?Object, ?Sub) -- true if Sub is a subobject of Object
   sub(O, S) :-
      ol_object(O, _, _),
      ol_super(S, O).

   % ancestor(?Object, ?Ancestor) -- true if Ancestor is an ancestor object of Object
   ancestor(O, A) :-
      ol_object(O, _, _),
      ol_ancestor(O, A).

   % descendant(?Object, ?Descendant) -- true if Descendant is a descendant object of Object
   descendant(O, D) :-
      ol_object(O, _, _),
      ol_descendant(O, D).


   :- publish defined/2, method/2, handler/3, attribute/2, val/3, o_attribute/2, o_val/3.

   % defined(?Object, ?Name/Arity) -- true if Name/Arity specifies a method
   %                                  defined in Object
   defined(O, N/A) :-
      ol_info(O, def, N/A).

   % method(?Object, ?Name/Arity) -- true if Name/Arity specifies a public
   %                                 method of Object
   method(O, M) :-
      ol_info(O, pub, M) ;   % public
      ol_info(O, ovr, M) ;   % overriding
      ol_info(O, inh, (_,M)).    % inherited

   % handler(+Object, +Name/Arity, ?Handler) -- true if Handler specifies the object
   %                                            that handles Method for Object
   handler(O, M, H) :-
      ol_info(O, def, M), \+ ol_info(O, pub, M), \+ ol_info(O, ovr, M), H=O ;  % private
      ol_info(O, pub, M), H=O ;   % public
      ol_info(O, ovr, M), H=O ;   % overriding
      ol_info(O, inh, (H,M)).     % inherited

   % attribute(+Instance, ?Name) -- true if Name is an attribute name in
   %                                Instance
   attribute(I, A) :-
      ol_attribute(I, A).

   % val(+Instance, +Attribute, ?Value) -- true if Value is the value of
   %                                       Attribute of Instance
   val(I, A, V) :-
      ol_val(I, A, V).

   % o_attribute(+ObjectInst, ?Name) -- true if Name is an attribute name in
   %                                    ObjectInst
   o_attribute(OI, A) :-
      arg(1, OI, I),
      ol_attribute(I, A).

   % o_val(+ObjectInst, +Attribute, ?Value) -- true if Value is the value of
   %                                           Attribute of ObjectInst
   o_val(OI, A, V) :-
      arg(1, OI, I),
      ol_val(I, A, V).


   % :- publish listing/1.


   :- publish goal/2.

   % goal(+Object::+Message, -Goal) -- Goal is the Prolog goal for O::M
   goal(O::M, Goal) :-
      ol_goal(O::M, Goal).


   :- publish all/2, and/2, or/2.

   % In the following three broadcast methods, only object names and simple
   % messages are allowed.

   % all(+Objects, +Message) -- true if O::Message true for all O in Objects
   %                            (independently)
   all(Os, M) :-
      \+ ( ol_member(O, Os),
           \+ O::M ).

   % and(+Objects, +Message) -- true if O::Message true for all O in Objects
   %                            (successively)
   and([], _).
   and([O|Os], M) :-
      O::M,
      this::and(Os, M).

   % or(+Objects, +Message) -- true if O::Message true for one O in Objects
   %                           (backtrackable)
   or([O|_], M) :-
      O::M.
   or([_|Os], M) :-
      this::or(Os, M).


   :- publish map/3.

   % map(+P, +L, ?M) -- true if the mapped list M with elements Yi is generated
   %                    from list L with elements Xi such that for all i:
   %                    self::P(Xi,Yi) (or self::N(Xi,Yi,...) if P is N(...))
   map(_, [], []).
   map(P, [H|T], [MH|MT]) :-
      P =.. [N|Ps],
      PM =.. [N,H,MH|Ps],
      ::PM,
      ::map(P, T, MT).

end_object ol.
