
object list.

   % This object contains the usual list methods.

   :- publish empty/1,          % empty([])
              equal/2,          % equal([a,b], [a,b])
              member/2,         % member(X, [a,b]), (X=a;X=b)
              append/3,         % append([a,b], [c], L), L=[a,b,c]
              reverse/2,        % reverse([a,b], L), L=[b,a]
              sublist/2,        % sublist([a,b,c,d], L),
                                % (L=[a];L=[a,b];...;L=[b];...)
              included/3,       % included(b, [a,b], L), L=[b,a,b]
              excluded/3,       % excluded(b, [a,b], L), L=[a]
              union/3,          % union([a,b], [a,c], L), L=[a,b,a,c]
              difference/3,     % difference([a,b], [b,c], L), L=[a]
              intersection/3,   % intersection([a,b], [b,c], L), L=[b]
              cardinality/2.    % cardinality([a,b,c], C), C=3

   empty(L) :-
      L == [].

   equal(Xs, Xs).

   member(X, [X|_]).
   member(X, [_|Xs]) :-
      this::member(X, Xs).

   append([], Ys, Ys).
   append([X|Xs], Ys, [X|Zs]) :-
      this::append(Xs, Ys, Zs).

   reverse(Xs, Ys) :-
      this::reverse(Xs, [], Ys).

   reverse([], Ys, Ys).
   reverse([X|Xs], Acc, Ys) :-
      this::reverse(Xs, [X|Acc], Ys).

   sublist([], []).
   sublist([X|Xs], [X|Ys]) :-
      ::append(Ys, _, Xs).
   sublist([_|Xs], Ys) :-
      ::sublist(Xs, Ys).

   included(X, Xs, [X|Xs]).

   excluded(X, [X|Xs], Xs).
   excluded(X, [Y|Xs], [Y|Ys]) :-
      ::excluded(X, Xs, Ys).

   union(Xs, Ys, Zs) :-
      ::append(Xs, Ys, Zs).

   difference([], _, []).
   difference([X|Xs], Ys, Zs) :-
      ::member(X, Ys),
      ::difference(Xs, Ys, Zs).
   difference([X|Xs], Ys, [X|Zs]) :-
      \+ ::member(X, Ys),
      ::difference(Xs, Ys, Zs).

   intersection([], _, []).
   intersection([X|Xs], Ys, [X|Zs]) :-
      ::excluded(X, Ys, Ys1),
      ::intersection(Xs, Ys1, Zs).
   intersection([X|Xs], Ys, Zs) :-
      \+ ::excluded(X, Ys, _),
      ::intersection(Xs, Ys, Zs).

   cardinality(Xs, L) :-
      length(Xs, L).

end_object list.

