
:- format("~n * Call `assistant::access(A)' and `student::access(A)'.~2n", []).

:- format("~n * Call `listener::solve(student::access(A))'.~2n", []).

object assistant.

   :- dynamic.
   :- publish permit/1, access/1.

   permit(total).

   access(A) :-
      self::permit(P),
      this::allowed(P, A).

   allowed(_, office).
   allowed(total, lab).

end_object assistant.


object student is_a assistant.

   :- dynamic.
   :- override permit/1, access/1.

   permit(restricted).

   access(library).
   access(A) :-
      super::access(A).

end_object student.
