%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	try.pl
%%% Author:	olin (Peter Olin) 
%%% Modified:	May 29, 1989
%%% Modified:	July 19, 1990 major rewrite for Andorra by Johan Bevemyr
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%%	Generates try, retry and trust instructions.
%%%	 switch_on_constant and switch_on_functor.
%%% 	
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	-					-
%%% Exports:	try_instructions/2 [DCG]
%%%
%%% Notes:	
%%% Bugs:
%%% Bugfixes:
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% try_instructions(Labels, Clauses) [DCG]
%%%

try_instructions(Clauses) -->
	{labelclauses(Clauses,LabeledClauses)},	 
	gen_try_schema(LabeledClauses), !,
	gen_code(LabeledClauses).
try_instructions(Clauses) -->
	clause_instructions(_,Clauses).

gen_try_schema(LabeledClauses) -->
        {
	    all_labels(LabeledClauses,DefaultLabels),
	    all_atom_labels(LabeledClauses,AtomLabels),
	    all_number_labels(LabeledClauses,NumberLabels),
	    all_list_labels(LabeledClauses,ListLabels),
	    all_structure_labels(LabeledClauses,FunctorLabels),
	    need_for_try_schema(DefaultLabels,AtomLabels,NumberLabels,
	                          ListLabels,FunctorLabels)
	},
%	 [switch_on_term(Lv,La,Ln,Ll,Ls)],
	 [switch_on_term(Lv,La,Ll,Ls)],
	 {thin_out_labels([(DefaultLabels,Lv),
	                   (AtomLabels,La),
	                   (NumberLabels,Ln),
	                   (ListLabels,Ll),
	                   (FunctorLabels,Ls)],
		          TryLabels)},
	gen_try_labels_and_instructions(TryLabels).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% need_for_try_schema(DefaultLabels,AtomLabels,NumberLabels,
%%%	                          ListLabels,FunctorLabels)
%%%
%%% The lists contains labels for respective group. The
%%% predicate shall test if there is any need for a try schema.
%%% That is if there is only variable-labels.
%%%

need_for_try_schema(Dl,Al,Nl,Ll,Fl):-
	length(Dl,Dn),
	length(Al,An),
	length(Nl,Nn),
	length(Ll,Ln),
	length(Fl,Fn),
	X is (Dn * 4) - (An + Nn + Ln + Fn),
	write(X),
	X > 0.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% gen_try_labels_and_instructions(LabelLabelsList) [DCG]
%%%

gen_try_labels_and_instructions([]) --> !.
gen_try_labels_and_instructions([(Trys,Label)|Rest]) -->
	gen_try_label_and_instruction(Label,Trys),
	gen_try_labels_and_instructions(Rest).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% gen_try_label_and_instruction(Labels,Clauses) [DCG]
%%%

gen_try_label_and_instruction(Lg,[]) --> !,
	{Lg = fail}.

%gen_try_label_and_instruction(Lg,[]) --> !,
%	[label(Lg),fail].

gen_try_label_and_instruction(Lg,[L]) --> !,
	{Lg = L}.

gen_try_label_and_instruction(Lg,GroupLabels) -->
	[label(Lg)],
	try_groups(GroupLabels).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% thin_out_labels(ListOfLabels,NotLongerListOfLabels)
%%%

thin_out_labels(AllLabels,NessesaryLabels):-
	sort(AllLabels,SortedLabels),
	no_doubled_trysequences(SortedLabels,NessesaryLabels).

no_doubled_trysequences([],[]).
no_doubled_trysequences([X],[X]).
no_doubled_trysequences([(Ts1,L1),(Ts2,L2)|Xs],Xs1):-
	Ts1 == Ts2, !,
	L1 = L2,
	no_doubled_trysequences([(Ts2,L2)|Xs],Xs1).
no_doubled_trysequences([(Ts1,L1),(Ts2,L2)|Xs],[(Ts1,L1)|Xs1]):-
	Ts1 \== Ts2,
	no_doubled_trysequences([(Ts2,L2)|Xs],Xs1).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% labelclauses(Clases,LabelesClauses)
%%%
	
labelclauses([],[]).
labelclauses([H|T],[(_,H)|NT]) :- labelclauses(T,NT).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% all_atom_labels(Clauses,LabelList)
%%%

all_atom_labels([],[]).
all_atom_labels([(L,C)|T],La) :-
	(is_atom_head(C) ; is_var_head(C)),
	!, La = [L|Ls],
	all_atom_labels(T,Ls).
all_atom_labels([_|T],Ls) :- all_atom_labels(T,Ls).

is_atom_head(Clause) :- head(Clause,[nil|_]).
is_atom_head(Clause) :- head(Clause,[atom(_)|_]).

is_var_head(Clause) :- head(Clause,[var(_,_)|_]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% all_number_labels(Clauses,LabelList)
%%%

all_number_labels([],[]).
all_number_labels([(L,C)|T],La) :-
	(is_number_head(C) ; is_var_head(C)),
	!, La = [L|Ls],
	all_number_labels(T,Ls).
all_number_labels([_|T],Ls) :- all_number_labels(T,Ls).

is_number_head(Clause) :- head(Clause,[number(_)|_]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% all_structure_labels(Clauses,LabelList)
%%%

all_structure_labels([],[]).
all_structure_labels([(L,C)|T],La) :-
	(is_structure_head(C) ; is_var_head(C)),
	!, La = [L|Ls],
	all_structure_labels(T,Ls).
all_structure_labels([_|T],Ls) :- all_structure_labels(T,Ls).

is_structure_head(Clause) :- head(Clause,[struct(_,_)|_]).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% all_list_labels(Clauses,LabelList)
%%%

all_list_labels([],[]).
all_list_labels([(L,C)|T],La) :-
	(is_list_head(C) ; is_var_head(C)),
	!, La = [L|Ls],
	all_list_labels(T,Ls).
all_list_labels([_|T],Ls) :- all_list_labels(T,Ls).

is_list_head(Clause) :- head(Clause,[cons(_,_)|_]).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% all_labels(Clauses,LabelList)
%%%

all_labels([],[]).
all_labels([(L,_)|T],[L|Ls]) :- all_labels(T,Ls).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% try_groups(LabelList)
%%%

try_groups([L|Ls]) --> [try(L)], try_groups_more(Ls).

try_groups_more([L]) --> !, [trust(L)].
try_groups_more([L|Ls]) --> [retry(L)], try_groups_more(Ls).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% gen_code(LabeledClauses)
%%%

gen_code([]) --> [].
gen_code([(L,C)|Cs]) -->
	[label(L)],
	compile_clause(C,switch),
	gen_code(Cs).


