%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	put.pl
%%% Author:	olin (Peter Olin) 
%%% Modified:	May 9, 1988
%%% Modified:	July 18, 1990 for Andorra by Johan Bevemyr
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%% This file contains the code for genrating the put-instructions
%%% for a clause
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	-					-
%%% Exports:	put_args/4 [DCG]
%%% Notes:	args(...) , not put- and unify-instructions.
%%% Bugs:	-
%%% Bugfixes:	-
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% put_args(Args,ArgNr)
%%%
%%% Currently put_args simply generates an args(...)-instruction if
%%% there are any arguments.
%%% Later it will generate put- and unify-instructions.

%%% For future use: (?)
%%% 
%%% The put- and unify-instructions will set up the arguments bottom-up.
%%% so substructures will be looked at before the actual 'super'-structure
%%% is taken care of.
%%%

put_args(Args) -->
	put_args(Args,0).

put_args([],_) --> !, [].			  %No arguments

put_args([Arg|Arglist],ArgNr) --> !,
	put_arg(Arg,ArgNr),
	{ArgNr1 is ArgNr + 1},
	put_args(Arglist,ArgNr1).


%%% WARNING!!! Copied from get*, may not be alright in all aspects.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% put_arg(Argument,Label,ArgumentNumber)
%%%
%%% Depending on Argument the following code is generated:
%%%
%%% # is the argument's position in the head.
%%%
%%%
%%%	nil		put_nil(a_reg(#))
%%%
%%%	atom(C)
%%%	number(C)	put_constant(C,a_reg(#)).
%%%
%%%	struct(F,A)	put_structure(F/Arity,a_reg(#))
%%%			   ... code for the arguments to F ...
%%%			   ... code for structure arguments ...
%%%			Arity = length of A, the list of arguments
%%%
%%%	cons(Car,Cdr)	put_list(a_reg(#))
%%%			   ... code for the elements in the list ...
%%%
%%% Variables occuring only once are ignored
%%%
%%%	var(_,void)	nothing (increase the argument counter)
%%%
%%% The first occurence of a variable is compiled to a put_variable-instruction
%%%
%%%	var(X,first)	put_variable(X,a_reg(#))
%%%
%%% The subsequent occurences of a variable is compiled to a put_value-instr.
%%%
%%%	var(X,nth)	put_value(X,a_reg(#))
%%%	
%%%  STRUCTURES
%%%
%%%  f(g(1),2,f(3))
%%%    compiles to
%%%
%%%  put_structure(f/2,a(#))     f(....)
%%%
%%%   unify_variable(a(7))         g(1)
%%%   unify_constant(2)            2
%%%   unify_variable(a(8))         f(3)
%%%   put_structure(g/1,a(7)       g( )
%%%   unify_constant(1)              1
%%%   put_structure(f/1,a(8))      f( )
%%%   unify_constant(3)              3
%%%
%%% We want the substructures to a struct/list in the argument
%%% to come after the top-level of the argument.
%%% LISTS
%%%
%%% cons(a,(cons(cons(b,nil),cons(c,nil)))) = [a,[b],c]
%%%
%%% put_list(a(#))	    cons(
%%%  unify_constant(a)            a,
%%%  unify_variable(a(7))           cons(...)
%%%   put_list(a(7))
%%%    unify_variable(a(8))
%%%    unify_variable(a(9))
%%%     put_list(a(8))
%%%      unify_constant(b)
%%%      unify_nil
%%%     put_list(a(9))
%%%      unify_constant(c)
%%%      unify_nil



% - NIL
put_arg(nil, ArgNr) --> !, [put_nil(ArgNr)].

% - ATOM
put_arg(atom(C),ArgNr) --> !, [put_constant(C,ArgNr)].

% - NUMBER
put_arg(number(C),ArgNr) --> !, [put_constant(C,ArgNr)].

% - VOID
put_arg(var(temp(_),void), ArgNr) --> !, [put_x_void(ArgNr)].

% - VOID
put_arg(var(perm(_),void), ArgNr) --> !, [put_y_void(ArgNr)].

%- first VAR
put_arg(var(perm(X),first), ArgNr) --> !, [put_y_variable(perm(X),ArgNr)].

% - nth VAR
put_arg(var(perm(X),nth),ArgNr) --> !, [put_y_value(perm(X),ArgNr)].

%- first VAR
put_arg(var(temp(X),first), ArgNr) --> !, [put_x_variable(temp(X),ArgNr)].

% - nth VAR
put_arg(var(temp(X),nth),ArgNr) --> !, [put_x_value(temp(X),ArgNr)].

% - STRUCTURE
put_arg(struct(F/1,[Args]),ArgNr) --> !,
	[put_structure(F/1,ArgNr)],
	unify_one_arg(Args,Sub), { Sub = none -> Sub1 = [] ; Sub1 = [Sub] },
	body_substructure_code(Sub1).

put_arg(struct(F,Args),ArgNr) --> !,
	[put_structure(F,ArgNr)],
	unify_struct_args(Args,Sub),
	body_substructure_code(Sub).

% - LIST
put_arg(cons(Car,Cdr), Arg) --> !,
	[put_list(Arg)],
	unify_cons_args(cons(Car,Cdr),Sub),
	body_substructure_code(Sub).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% body_substructure_code(Substructures)
%%% 

body_substructure_code([]) --> [].
body_substructure_code([sub(Reg,StructOrList)|Subs]) -->
	body_unify_sub_arg(Reg,StructOrList),
	body_substructure_code(Subs).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% unify_sub_arg(Arg,Substructure)
%%%
%%% 


% - STRUCT
body_unify_sub_arg(Reg,struct(F/1,[Args])) --> !,
	[get_structure(F/1,Reg)],
	unify_one_arg(Args,Sub), { Sub = none -> Sub1 = [] ; Sub1 = [Sub] },
	body_substructure_code(Sub1).

body_unify_sub_arg(Reg,struct(F,Args)) --> !,
	[get_structure(F,Reg)],
	unify_struct_args(Args,Sub),
	body_substructure_code(Sub).

% - LIST
body_unify_sub_arg(Reg,cons(Car,Cdr)) --> !, 
	[get_list(Reg)],
	unify_cons_args(cons(Car,Cdr),Sub),
	body_substructure_code(Sub).

