%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	body.pl
%%% Author:	olin (Peter Olin) 
%%% Modified:	Apr 10, 1989
%%% Modified:	July 18, 1990 for Andorra by Johan Bevemyr
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%% This file contains the code for compiling the body of a clause.
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	put_args/3 [DCG]			put.pl
%%% Exports:	body_code/3 [DCG]
%%%		goal_code/3 [DCG]
%%%		
%%% Notes:	-
%%% Bugs:	-
%%% Bugfixes:	-
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% body_code(Body,Label,Register)
%%%
%%% +Body	body([call(Name1/Arity,Args),
%%%		      call(Name2/Arity,Args),
%%%       	      ...
%%%       	      call(NameN/Arity,Args)])
%%%
%%% -Label 	Uninstantiated label used to connect jumps and addresses.
%%%
%%% +Register	For future use,
%%%
%%%
%%%
%%% Recursively generates the code for each subgoal of Body. The first
%%% instruction in the code sequence generated is placed at L.
%%%       

body_code(SubGoals) -->
	body_code_aux(SubGoals).


body_code_aux([]) --> !,			% No goals in body
	[proceed,deallocate].

body_code_aux([Last]) --> !,			% Last goal (execute)
	goal_code(last,Last).

body_code_aux([First|Rest]) --> !,		  
	goal_code(notlast, First),		% Intermed. goal (call)
	body_code_aux(Rest).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% goal_code(Flag, Subgoal,Label)
%%%
%%% +Flag	notlast/last determines  call/execute.
%%%
%%% +Subgoal	One of two cases:
%%% 		1)  Subgoal is a conditional goal, the main functor is "->"
%%% 		2)  Subgoal is an ordinary goal
%%%
%%% -Label	Uninstantiated label used to connect jumps and addresses
%%%
%%%
%%%
%%% There are two cases:
%%% a) This is not the last goal, so generate a call(...)
%%% b) This is the last goal, generate an execute(...)

goal_code(L, call(call/1,Arglist)) --> !,
        put_args(Arglist),
   	[meta_call(0)],
	proceed(L).

goal_code(_, call(fail/0,_)) --> !,
   	[fail].

goal_code(notlast, call(NameArity,Arglist)) --> !,
        put_args(Arglist),
   	[call(NameArity)].

goal_code(last, call(NameArity,Arglist)) --> !,
        put_args(Arglist),
	[deallocate,execute(NameArity)].
%%	[execute(NameArity)].

goal_code(L, builtin(Name/Arity,Args,Type)) --> !,
	builtin_code(Type,Arity,Name,Args),
	proceed(L).

%% goal_code(L, guard(commit)) --> !,
%% 	[guard_commit],
%% 	proceed(L).
%% 
%% goal_code(L, guard(cut)) --> !,
%% 	[guard_cut],
%% 	proceed(L).
%% 
%% goal_code(L, guard(wt)) --> !,
%% 	[guard_wait],
%% 	proceed(L).

goal_code(L, unify(X,Y)) --> !,
	put_args([X]),
	get_args([Y],0),
	proceed(L).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% proceed
%%%

proceed(notlast) --> [].
proceed(last) --> [proceed].


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% builtin_code(Type, Arity, Name, Args)
%%%

% builtin_code(may_suspend,2,Name,Args) --> !,
% 	args_into_y(Args,Yreg1,Yreg2),
% 	[builtin_s_2(Name/2,Yreg1,Yreg2)].
% 
% builtin_code(fail_succeed,0,Name,_) --> !,
% 	[builtin_0(Name/0)].
% 
% builtin_code(fail_succeed,1,Name,ArgList) --> !,
% 	put_args(ArgList),
% 	[builtin_1(Name/1,0)].
% 
% builtin_code(fail_succeed,2,Name,ArgList) --> !,
% 	put_args(ArgList),
% 	[builtin_2(Name/2,0,1)].
% 
% builtin_code(fail_succeed,3,Name,ArgList) --> !,
% 	put_args(ArgList),
% 	[builtin_3(Name/3,0,1,2)].
% 
% 
% builtin_code(function,3,Name,[Res|Args]) -->
% 	put_args(Args,1),
% 	[function_2(Name/3,0,1,2)],
% 	get_args([Res],0).

builtin_code(_,0,halt,_) --> [halt].

builtin_code(_,Arity,Name,ArgList) --> !,
	put_args(ArgList),
	[builtin(Name/Arity)].


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% arg_into_y
%%%

arg_into_y(var(perm(Y),_),Y) --> !,[].
arg_into_y(F,X) --> !,
	put_args([F]),
	[get_y_variable(perm(X),0)].

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% args_into_y
%%%

args_into_y([Arg1,Arg2],Yreg1,Yreg2) --> !,
	arg_into_y(Arg1,Yreg1),
	arg_into_y(Arg2,Yreg2).








