%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	allocate.pl
%%% Author:	olin (Peter Olin) 
%%% Modified:	May 30, 1989
%%% Modified:	July 18, 1990 for Andorra by Johan Bevemyr
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%%	This file contains the code for allocating registers.
%%% 	
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	
%%%
%%% Exports:	
%%% Notes:	
%%% Bugs:	-
%%% Bugfixes:	-
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% allocate_registers
%%% 
%%%
%%% Takes the TROLL WAM-instructions one-by-one and allocates register-values
%%% to all variables.  The registers are recorded so that subsequent
%%% occurences of the same variable is allocated to the same register.
%%% This is achieved by using var/1 to check that a *new* register should
%%% be allocated and instantiating the variable when a register has been
%%% allocated to it.

allocate_registers1(Code,RegisterTable,PV) -->
	{allocate_registers(Code,RegisterTable,regcount(_,PV),AllCode,[]),
	 remove_allocate0(AllCode,AllCode2)},
	 AllCode2.


allocate_registers([],TP,TP) --> [].
allocate_registers([Instr|Code],TP,TP1) -->
	allocate_register(Instr,TP,TP0),
	allocate_registers(Code,TP0,TP1).


remove_allocate0([allocate(0)|C0],C1) :- 
	remove_deallocate0(C0,C1), !.
remove_allocate0([allocate(_)|C],[allocate|C]).

remove_deallocate0([deallocate|C],C).
remove_deallocate0([X|Xs],[X|C]) :-
	remove_deallocate0(Xs,C).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% unallocated(Var)
%%% if Var is currently unallocated.

unallocated(temp(X)) :- !, var(X).
unallocated(perm(X)) :- !, var(X).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% 
%%% allocate(Var,RegCount,Var1,RegCount1)
%%% is only called if Var is unallocated. Allocates Var and increases the
%%% appropriate register-count.

allocate(perm(X),regcount(T,P),P,regcount(T,P1)) :- !,
	X = P,
	P1 is P+1.
	
allocate(temp(X),regcount(T,P),T,regcount(T1,P)) :- !,
	X = T,
	T1 is T+1.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% allocate_register(Instruction, RegCount, RegCount1) [DCG]
%%% generates a new instruction sequence, with all variables allocated.
%%% 

allocate_register(unify_x_variable(Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[unify_x_variable(Var1)].

allocate_register(unify_x_value(Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[unify_x_value(Var1)].

allocate_register(unify_x_value(temp(Var)),TP,TP) --> !,
	[unify_x_value(Var)].

allocate_register(unify_y_variable(Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[unify_y_variable(Var1)].

allocate_register(unify_y_value(Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[unify_y_value(Var1)].

allocate_register(unify_y_value(perm(Var)),TP,TP) --> !,
	[unify_y_value(Var)].

allocate_register(get_x_variable(Var,Reg),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[get_x_variable(Var1,Reg)].

allocate_register(get_x_value(Var,Reg),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[get_x_value(Var1,Reg)].

allocate_register(get_x_value(temp(Var),Reg),TP,TP) --> !,
	[get_x_value(Var,Reg)].

allocate_register(get_y_variable(Var,Reg),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[get_y_variable(Var1,Reg)].

allocate_register(get_y_value(Var,Reg),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[get_y_value(Var1,Reg)].

allocate_register(get_y_value(perm(Var),Reg),TP,TP) --> !,
	[get_y_value(Var,Reg)].

allocate_register(get_structure(Str,Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[get_structure(Str,Var1)].

allocate_register(get_structure(Str,temp(Var)),TP,TP) --> !,
	[get_structure(Str,Var)].

allocate_register(get_list(temp(Var)),TP,TP1) -->
	{unallocated(temp(Var)),!,allocate(temp(Var),TP,Var1,TP1)},
	[get_list(Var1)].

allocate_register(get_list(temp(Var)),TP,TP) -->
	[get_list(Var)].

allocate_register(put_x_variable(Var,Reg),regcount(T,P),TP1) -->
	{temp_not_less(Reg,T,T1),
	 unallocated(Var),!,allocate(Var,regcount(T1,P),Var1,TP1)},
	[put_x_variable(Var1,Reg)].

allocate_register(put_x_value(Var,Reg),regcount(T,P),TP1) -->
	{temp_not_less(Reg,T,T1),
	 unallocated(Var),!,allocate(Var,regcount(T1,P),Var1,TP1)},
	[put_x_value(Var1,Reg)].

allocate_register(put_x_value(temp(Var),Reg),regcount(T,P),regcount(T1,P)) --> !,
	{temp_not_less(Reg,T,T1)},
	[put_x_value(Var,Reg)].

allocate_register(put_y_variable(Var,Reg),regcount(T,P),TP1) -->
	{temp_not_less(Reg,T,T1),
	 unallocated(Var),!,allocate(Var,regcount(T1,P),Var1,TP1)},
	[put_y_variable(Var1,Reg)].

allocate_register(put_y_value(Var,Reg),regcount(T,P),TP1) -->
	{temp_not_less(Reg,T,T1),
	 unallocated(Var),!,allocate(Var,regcount(T1,P),Var1,TP1)},
	[put_y_value(Var1,Reg)].

allocate_register(put_y_value(perm(Var),Reg),regcount(T,P),regcount(T1,P)) --> !,
	{temp_not_less(Reg,T,T1)},
	[put_y_value(Var,Reg)].

allocate_register(put_structure(Str,Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[put_structure(Str,Var1)].

allocate_register(put_structure(Str,temp(Var)),TP,TP) --> !,
	[put_structure(Str,Var)].

allocate_register(put_structure(Str,Reg),regcount(T,P),regcount(T1,P)) --> !,
	{temp_not_less(Reg,T,T1)},
	[put_structure(Str,Reg)].

allocate_register(put_constant(Con,Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[put_constant(Con,Var1)].

allocate_register(put_constant(Con,temp(Var)),TP,TP) -->
	[put_constant(Con,Var)].

allocate_register(put_constant(Con,Reg),regcount(T,P),regcount(T1,P)) -->
	{temp_not_less(Reg,T,T1)},
	[put_constant(Con,Reg)].

allocate_register(put_list(Var),TP,TP1) -->
	{unallocated(Var),!,allocate(Var,TP,Var1,TP1)},
	[put_list(Var1)].

allocate_register(put_list(temp(Var)),TP,TP) --> !,
	[put_list(Var)].

allocate_register(put_list(Reg),regcount(T,P),regcount(T1,P)) --> !,
	{temp_not_less(Reg,T,T1)},
	[put_list(Reg)].

%%% Absolute nonsense, guard call on nonexistent variable.
allocate_register(var(X),TP,TP1) -->
	{var(X),!,allocate(X,TP,Var1,TP1)},
	[var(Var1)].
allocate_register(nonvar(X),TP,TP1) -->
	{var(X),!,allocate(X,TP,Var1,TP1)},
	[nonvar(Var1)].
allocate_register(ground(X),TP,TP1) -->
	{var(X),!,allocate(X,TP,Var1,TP1)},
	[ground(Var1)].
allocate_register(atom(X),TP,TP1) -->
	{var(X),!,allocate(X,TP,Var1,TP1)},
	[atom(Var1)].
allocate_register(number(X),TP,TP1) -->
	{var(X),!,allocate(X,TP,Var1,TP1)},
	[number(Var1)].
allocate_register(atomic(X),TP,TP1) -->
	{var(X),!,allocate(X,TP,Var1,TP1)},
	[atomic(Var1)].

allocate_register(call(Pred),TP,TP) -->
	{env_size(TP,Size)},
	[call(Pred,Size)].

allocate_register(Instr,T,T) --> [Instr].

temp_not_less(Reg,T,T) :- Reg < T, !.
temp_not_less(Reg,_,T) :- T is Reg + 1.

env_size(regcount(_,P),P).
