%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	translate.pl
%%% Author:	olin (Peter Olin) 
%%% Modified:	Dec 16, 1988
%%% Modified:	July 18, 1990 for Andorra by Johan Bevemyr
%%% Modified:	November 25, 1993 for WAM by Katrin Boberg
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%% 	Translates the Prolog-style instructions 
%%%     to Lisp-style instructions.
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	-					-
%%%
%%% Exports:	lisp_print_instruction/2
%%%		
%%% Notes:	No comments :-)
%%% Bugs:	-
%%% Bugfixes:	-
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


lisp_print_instruction(X,Stream) :-
	nl(Stream), numbervars(X,0,_),!,
	print_wam_code(Stream,X).

print_wam_code(Stream,predicate(Name/Arity,Instr)) :- 
	format(Stream,"(predicate ~w ~w~n",[Name,Arity]),
	format(Stream,"  (~n",[]),
	print_instr(Stream,Instr),!.

print_instr(Stream,[]) :- 
	format(Stream,"  )~n",[]),
	format(Stream,")~n",[]).
print_instr(Stream,[H|T]) :- 
	one_indent(H), !,
	tab(Stream,4),
	print_inst(H,Stream),
	print_instr(Stream,T).
print_instr(Stream,[H|T]) :- 
	two_indent(H), !,
	tab(Stream,8),
	print_inst(H,Stream),
	print_instr(Stream,T).
print_instr(Stream,[H|T]) :- 
	three_indent(H), !,
	tab(Stream,7),
	print_inst(H,Stream),
	print_instr(Stream,T).
print_instr(Stream,[H|T]) :-
	tab(Stream,12),
	print_inst(H,Stream),  
	print_instr(Stream,T).


print_inst(Instruction,Stream):-
	lisp_translate(Instruction,LispInstr),
	functor(LispInstr,Name,Arity),
	format(Stream,"(~w",[Name]),
	print_inst_args(0,Arity,LispInstr,Stream).

print_inst_args(N,N,_,Stream):- !,
	format(Stream,")~n",[]).
print_inst_args(N,Arity,Instruction,Stream):-
	N < Arity,
	N1 is N+1,
	arg(N1,Instruction,Arg),
	print_arg(Arg,Stream),
	print_inst_args(N1,Arity,Instruction,Stream).

print_arg(N/A,Stream):-
	format(Stream," (~w . ~q)",[N,A]).
print_arg(X,Stream):-
	format(Stream," ~w",[X]).


% two_indent(try_me).
% two_indent(try_me_else(_)).
% two_indent(retry_me_else(_)).
% two_indent(trust_me).
% two_indent(try_single(_)).
% two_indent(try(_)).
% two_indent(retry(_)).
% two_indent(trust(_)).

two_indent(foo).
three_indent(foo).

one_indent(label(_)).

one_indent(switch_on_term(_,_,_,_)).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% lisp_translate(Prologsyntax,Lispsyntax)
%%%
%%% This predicate changes all '_' to '-'. It also
%%% converts '*_x0' instructions to '* 0' instructions.
%%%

lisp_translate(switch_on_term(A,B,C,D), 'switch-on-term'(A,B,C,D)).
lisp_translate(switch_on_constant(A,B),'switch-on-constant'(A,B)).
lisp_translate(switch_on_structure(A,B), 'switch-on-structure'(A,B)).
lisp_translate(try(X), try(X)).
lisp_translate(retry(X),retry(X)).
lisp_translate(trust(X),trust(X)).
lisp_translate(try_me_else(X),'try-me-else'(X)).
lisp_translate(retry_me_else(X),'retry-me-else'(X)).
lisp_translate(trust_me,'trust-me').
lisp_translate(choice_x(X),'choice-x'(X)).
lisp_translate(choice_y(X),'choice-y'(X)).

lisp_translate(cut,cut).
lisp_translate(cut_x(X),'cut-x'(X)).
lisp_translate(cut_y(X),'cut-y'(X)).
lisp_translate(allocate,allocate).
lisp_translate(deallocate,deallocate). 
lisp_translate(call(F,E),call(F,E)).
lisp_translate(execute(F),execute(F)).
lisp_translate(proceed,proceed).
lisp_translate(fail,fail).

lisp_translate(get_x_variable(X,Y),'get-x-variable'(X,Y)).
lisp_translate(get_y_variable(X,Y),'get-y-variable'(X,Y)).
lisp_translate(get_y_first_value(X,Y),'get-y-first-value'(X,Y)).
lisp_translate(get_x_value(X,Y),'get-x-value'(X,Y)).
lisp_translate(get_y_value(X,Y),'get-y-value'(X,Y)).
lisp_translate(get_constant(C,X),'get-constant'(C,X)).
lisp_translate(get_constant_x0(C),'get-constant'(C,0)).
lisp_translate(get_nil(X),'get-nil'(X)).
lisp_translate(get_nil_x0,'get-nil'(0)).
lisp_translate(get_structure(F,X),'get-structure'(F,X)).
lisp_translate(get_structure_x0(F),'get-structure'(F,0)).
lisp_translate(get_list(X),'get-list'(X)).
lisp_translate(get_list_x0,'get-list'(0)).

lisp_translate(put_x_void(X),'put-x-void'(X)).
lisp_translate(put_y_void(X),'put-y-void'(X)).
lisp_translate(put_x_variable(X,Y),'put-x-variable'(X,Y)).
lisp_translate(put_y_variable(Y,X),'put-y-variable'(Y,X)).
lisp_translate(put_x_value(X,Y),'put-x-value'(X,Y)).
lisp_translate(put_y_value(X,Y),'put-y-value'(X,Y)).
lisp_translate(put_x_unsafe_value(X,Y),'put-x-unsafe-value'(X,Y)).
lisp_translate(put_y_unsafe_value(X,Y),'put-y-unsafe-value'(X,Y)).
lisp_translate(put_constant(C,X),'put-constant'(C,X)).
lisp_translate(put_nil(X),'put-nil'(X)).
lisp_translate(put_structure(F,X),'put-structure'(F,X)).
lisp_translate(put_list(X),'put-list'(X)).

lisp_translate(unify_void,'unify-void'(1)).
lisp_translate(unify_void(X),'unify-void'(X)).
lisp_translate(unify_x_variable(X),'unify-x-variable'(X)).
lisp_translate(unify_y_variable(X),'unify-y-variable'(X)).
lisp_translate(unify_y_first_value(Y),'unify-y-first-value'(Y)).
lisp_translate(unify_x_value(X),'unify-x-value'(X)).
lisp_translate(unify_y_value(Y),'unify-y-value'(Y)).
lisp_translate(unify_x_local_value(X),'unify-x-local-value'(X)).
lisp_translate(unify_y_local_value(Y),'unify-y-local-value'(Y)).
lisp_translate(unify_constant(C),'unify-constant'(C)).
lisp_translate(unify_nil,'unify-nil').
lisp_translate(unify_structure(F),'unify-structure'(F)).
lisp_translate(unify_list,'unify-list').

lisp_translate(halt,halt).
lisp_translate(label(X),label(X)).

lisp_translate(X,_) :- write('warning: cannot translate '), write(X), nl.
