%%%
%%% append(Xs,Ys,Zs) if Zs is the concatenation of Xs and Ys
%%%

%append([],Ys,Ys).
%append([X|Xs],Ys,[X|Zs]) :-
%	append(Xs,Ys,Zs).

%%%
%%% member(X,Xs) if X is in Xs
%%%

member(X,[X|_]).
member(X,[_|Ys]) :-
	member(X,Ys).

%%% 
%%% climb(Trappstorlek,Steg)
%%% 

climb(0,[]).
climb(N,[S|Ss]):-
        N > 0,
        step(S),
        N1 is N-S,
        climb(N1,Ss).
 
step(1).
step(2).

%%% 
%%% permute(X,Y) if Y is the permutation of the list X.
%%% 

permute([],[]).
permute(L,[X|Xs]):-
        select(L,X,L1),
        permute(L1,Xs).
 
%%% 
%%% select(L1,A,L2) if A is an element of the list L1 and L2 is L1 without A.
%%% 

select([X|Xs],X,Xs).
select([X|Xs],Y,[X|Ys]):-
        select(Xs,Y,Ys).


%%%
%%% bug1/2 - Testar unsafe variables.
%%%

bug1(A,[A|B]).


%%%
%%% bug2/0 - Testar void-variabler, man vill inte fa dessa som perm(...).
%%%

bug2:-append(A,B,[a,b,c,d,e]),append(C,[D|E],A),halt.
