%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	print.pl
%%% Author:	Katrin Boberg (katrin)
%%% Modified:	
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%% 	Contains the code for printing the generated code
%%%     in prolog format.
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	prolog_print_instruction/2              translate.pl
%%%
%%% Exports:	write_header/2
%%%		write_footer/2
%%%		printcode/3
%%%
%%% Notes:	
%%% Bugs:
%%% Bugfixes:
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%

write_header(prolog, _).
write_header(lisp, _).

write_footer(prolog,_).
write_footer(lisp,_).

printcode(prolog,Stream,X,Predicate) :-
	nl(Stream),	
	print_predicate(Predicate,Stream),
	prologprintcode(X,Stream),
	nl(Stream).

printcode(lisp,Stream,X,Predicate) :-
	nl(Stream),	
	lisp_print_predicate(Predicate,Stream),
	lispprintcode(X,Stream),
	nl(Stream).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% print_predicate(Clauses,Stream)
%%%
%%% +Clauses      All the predicates original clauses.
%%%
%%% +Stream       The outputstream.
%%%

print_predicate([],_).
print_predicate([P|_],Stream) :-
	numbervars(P,0,_),
	write(Stream,'% '),
	write(Stream,P), write(Stream,'.'),
	nl(Stream),
	fail.
print_predicate([_|Ps],Stream) :-
	print_predicate(Ps,Stream).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% lisp_print_predicate(Clauses,Stream)
%%%
%%% +Clauses      All the predicates original clauses.
%%%
%%% +Stream       The outputstream.
%%%

lisp_print_predicate([],_).
lisp_print_predicate([P|_],Stream) :-
	numbervars(P,0,_),
	write(Stream,';; '),
	write(Stream,P), write(Stream,'.'),
	nl(Stream),
	fail.
lisp_print_predicate([_|Ps],Stream) :-
	lisp_print_predicate(Ps,Stream).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% prologprintcode(Code,Stream)
%%%
%%% +Code        The generated code.
%%%
%%% +Stream      The output filestream for the TROLL WAM code.
%%%

prologprintcode([],Stream) :- nl(Stream).
prologprintcode([X|Xs],Stream) :-
	prolog_print_instruction(X,Stream),
	prologprintcode(Xs,Stream).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% lispprintcode(Code,Stream)
%%%
%%% +Code        The generated code.
%%%
%%% +Stream      The output filestream for the TROLL WAM code.
%%%

lispprintcode([],Stream) :- nl(Stream).
lispprintcode([X|Xs],Stream) :-
	lisp_print_instruction(X,Stream),
	lispprintcode(Xs,Stream).

