%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%	File: 		lifespan.pl
%%%	Author:		Peter Olin
%%%	Date:		June 5, 1989
%%%     Modified:       July 18, 1990 for Andorra by Johan Bevemyr
%%%	Purpouse:	To analyze the varaibles in a clause to determine
%%%			wheter they should be temporary - temp(...)
%%%			or permanent - perm(...)
%%%		 
%%%
%%% HISTORY
%%% Author	Date		Description
%%% PO		5/6-89		Extracted from parser.pl
%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% body_lifespan(Body)
%%%
%%% +-Body	Body with uninstantiated variables, which are partially
%%%		instantiated to either temp(...) or perm(...)
%%%
%%%
%%%
%%% This predicate instantiates the variables in Body with structures 
%%% reflecting their status.  In fact all variables are made
%%% permanent.  head_lifespan works in the same way, but all 
%%% variables only occuring in the head are made temporary.
%%%
%%% Katrins changes:
%%% This should make it more like WAM with the perm/temp:s.


body_lifespan([],N,N).
body_lifespan([X|Xs],N0,N):-
	body_lifespan_calls(Xs,N0,N1),
	body_lifespan_call(X,first_goal,N1,N).

body_lifespan_calls([],N,N).
body_lifespan_calls([X|Xs],N0,N):-
	body_lifespan_calls(Xs,N0,N1),
	body_lifespan_call(X,nth_goal,N1,N).

body_lifespan_call(call(_,Arglist),Flag,N,N1) :-
	body_arglist_lifespan(Arglist,Flag,N,N1).

body_lifespan_call(unify(X,Y),Flag,N,N1) :-
	body_arglist_lifespan([X,Y],Flag,N,N1).

body_lifespan_call(builtin(_,Arglist,_),Flag,N,N1) :-
	body_arglist_lifespan(Arglist,Flag,N,N1).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% body_arglist_lifespan(Arglist)
%%%
%%% +-Arglist
%%%
%%%
%%%

body_arglist_lifespan([],_,N,N).
body_arglist_lifespan([Arg|Arglist],Flag,N,N1) :-
	body_term_lifespan(Arg,Flag,N,N0),
	body_arglist_lifespan(Arglist,Flag,N0,N1).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% body_term_lifespan(Term)
%%%
%%% +-Term	Term
%%%
%%%
%%%
%%% Calculates the lifespan of all variables in Term. (They are all permanent).
%%% There are a number of cases which must be taken care of. We assume that
%%% complex body forms are taken care of already, so we only have to 
%%% look at ordinary Prolog (GCLA) terms.
%%%
%%%

body_term_lifespan(nil,_,N,N).
body_term_lifespan(atom(_),_,N,N).
body_term_lifespan(number(_),_,N,N).
body_term_lifespan(cons(Car,Cdr),Flag,N,N1) :-
	body_term_lifespan(Car,Flag,N,N0), 
	body_term_lifespan(Cdr,Flag,N0,N1).
body_term_lifespan(struct(_,Arglist),Flag,N,N1) :-
	body_struct_args_lifespan(Arglist,Flag,N,N1).
body_term_lifespan(var(X,_,_),first_goal,N,N1) :- 
	var(X),!,X = temp(_),N1 is N+1.
body_term_lifespan(var(X,_,Status),nth_goal,N,N1) :- 
	var(X),Status == void,!,X = temp(_),N1 is N+1.
body_term_lifespan(var(X,_,_),nth_goal,N,N1) :- 
	var(X),!,X = perm(_),N1 is N+1.
body_term_lifespan(var(temp(_),_,_),_,N,N).			
body_term_lifespan(var(perm(_),_,_),_,N,N).			

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% body_struct_args_lifespan(Args)
%%%
%%%
%%% 
%%% traverses the arguments to a struct occuring in the body of a clause

body_struct_args_lifespan([],_,N,N).
body_struct_args_lifespan([Arg|Args],Flag,N,N1) :-
	body_term_lifespan(Arg,Flag,N,N0),
	body_struct_args_lifespan(Args,Flag,N0,N1).




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% head_lifespan(Arglist)
%%%
%%% +-Arglist
%%%
%%%
%%%
%%% Should split arrows into their parts.

head_lifespan([]).
head_lifespan([Arg|Arglist]) :-
	head_term_lifespan(Arg),
	head_lifespan(Arglist).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% head_term_lifespan(Term)
%%%
%%% +-Term	Term
%%%
%%%
%%%
%%% Calculates the lifespan of all variables in Term. (They are all temporary).
%%% There are a number of cases which must be taken care of. 
%%%
%%%

head_term_lifespan(nil).
head_term_lifespan(atom(_)).
head_term_lifespan(number(_)).
head_term_lifespan(cons(Car,Cdr)) :-
	head_term_lifespan(Car), 
	head_term_lifespan(Cdr).
head_term_lifespan(struct(_,Arglist)) :- head_struct_args_lifespan(Arglist).
head_term_lifespan(var(X,_,_)) :- var(X),!,X = temp(_).
head_term_lifespan(var(temp(_),_,_)).			
head_term_lifespan(var(perm(_),_,_)).			

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% head_struct_args_lifespan(Args)
%%%
%%%
%%% 
%%% traverses the arguments to a struct occuring in the head of a clause

head_struct_args_lifespan([]).
head_struct_args_lifespan([Arg|Args]) :-
	head_term_lifespan(Arg),
	head_struct_args_lifespan(Args).



