%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%% Filename:	library.pl
%%% Author:	olin (Peter Olin) 
%%% Modified:	May 9, 1989
%%% Modified:	18 July, 1990 for Andorra by Johan Bevemyr
%%% Version:	1.2 (unfinished)
%%% 
%%% Description:
%%% 	Contains various useful predicates missing in SICStus.
%%% 
%%%
%%%		Predicate				File
%%%		---------				----
%%% Requires:	-					-
%%%
%%% Exports:	member/2
%%%		non_member/2
%%%		append/3
%%%		mapcar/3
%%%		maplist/4
%%%		remove_duplicates/2
%%%		ground/1
%%%		baggof/3
%%%             listify/2
%%%		
%%% Notes:	No comments :-)
%%% Bugs:	-
%%% Bugfixes:	-
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




%%%
%%% member(X,Xs) if X is in Xs
%%%

member(X,[X|_]).
member(X,[_|Ys]) :-
	member(X,Ys).


%%%
%%% non_member(X,Xs) if X is not in Xs
%%%

non_member(X,[Y|Ys]) :- X \== Y, non_member(X,Ys).
non_member(_,[]).

%%%
%%% append(Xs,Ys,Zs) if Zs is the concatenation of Xs and Ys
%%%

append([],Ys,Ys).
append([X|Xs],Ys,[X|Zs]) :-
	append(Xs,Ys,Zs).


%%%
%%% mapcar(Xs,Pred,Ys) if Pred holds among matching elements in Xs and Ys
%%%

mapcar([],_,[]).
mapcar([X|Xs],Function,[Y|Ys]) :-
	Call =.. [Function,X,Y],
	Call,
	mapcar(Xs,Function,Ys).



%%%
%%% mapcar(Xs,Pred) if Pred is true for all elements is Xs
%%%

mapcar([],_).
mapcar([X|Xs],Function) :-
	Call =..[Function,X],
	Call,
	mapcar(Xs,Function).




%%%
%%% maplist(List,Pred,Arg2,List2)
%%%      if List is the result of applying Pred to all elements in List with
%%%         Arg2 as the second argument to Pred.
%%%

maplist([],_,_,[]) :- !.
maplist([X|Xs],Pred,Arg,[Y|Ys]) :-
	FOO =.. [Pred,X,Arg,Y],
	FOO,
	maplist(Xs,Pred,Arg,Ys).


%%%
%%% remove_duplicates(Xs,Ys) if Ys contains all distinct elements is Xs.
%%%

remove_duplicates([X|Xs],Ys) :-
	member(X,Xs),!,
	remove_duplicates(Xs,Ys).
remove_duplicates([X|Xs],[X|Ys]) :-
	non_member(X,Xs),!,
	remove_duplicates(Xs,Ys).
remove_duplicates([],[]).


%%%
%%% ground(Term) if Term is ground.
%%%


%Finns i Sicstus% ground(Term) :-
%Finns i Sicstus% 	atomic(Term)
%Finns i Sicstus% 	;nonvar(Term),
%Finns i Sicstus% 	 ground1(Term).
%Finns i Sicstus% 
%Finns i Sicstus%  ground1(Term) :- 
%Finns i Sicstus% 	 Term = [Car|Cdr],!,
%Finns i Sicstus% 	 ground(Car),ground(Cdr).
%Finns i Sicstus%  ground1(Term) :-
%Finns i Sicstus% 	 functor(Term,_,Arity),!,
%Finns i Sicstus% 	 ground_args(Term,Arity).
%Finns i Sicstus% 
%Finns i Sicstus%   ground_args(_,0) :- !.
%Finns i Sicstus%   ground_args(Term,N) :-
%Finns i Sicstus% 	  arg(N,Term,Arg),
%Finns i Sicstus% 	  ground(Arg),
%Finns i Sicstus% 	  N1 is N -1,
%Finns i Sicstus% 	  ground_args(Term,N1).

%%%
%%% delete(X,List,List2) if List2 is List with X removed
%%%

%delete(X,[],[]).

delete(X,[X|L],L).
delete(X,[Y|L],[Y|L1]) :- delete(X,L,L1).


%%%
%%% last (List,E) if E is the last element in  List.
%%%

last([X],X).
last([_|Rest],X) :- last(Rest,X).


%%%
%%% subset(Set1,Set2) if Set1 is a Subset of Set2.
%%%

subset([X|Xs],Ys) :- remove(X,Ys,Ys1),subset(Xs,Ys1).
subset([],_).


%%%
%%% baggof(Template,Query, Bag)
%%%

baggof(Template, Query, Bag) :- bagof(Template,Query,Bag), !.
baggof(_,_,[]).

%%%
%%% reverse(L,R)
%%%

same_length([],[]).
same_length([_|X],[_|Y]) :-
    same_length(X,Y).

reverse(L,R) :-
    same_length(L,R),
    reverse(L,[],R).

reverse([],R,R).
reverse([X|L],R0,R) :-
    reverse(L,[X|R0],R).

%%% 
%%% listify/2
%%% 

listify(F,[F]) :-
	\+ F = (_,_).
listify((H,B),[H|R]) :- listify(B,R).
