/*    File:	 time.c  (~bevemyr/BIN/Emulator/time.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Apr 26 17:30:58 1993
 */ 

#include "include.h"
#include <sys/stat.h>

#if (SUN_BSD || APOLLO)

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>

struct rusage t;

long usertime()
{
  if(getrusage(RUSAGE_SELF,&t) != 0) {
    printf(stderr,"OS error: getrusage error\n");
    return 0;
  }
  return t.ru_utime.tv_sec*1000 + t.ru_utime.tv_usec / 1000;
}
    
long systime()
{
  if(getrusage(RUSAGE_SELF,&t) != 0) {
    printf(stderr,"OS error: getrusage error\n");
    return 0;
  }
  return t.ru_stime.tv_sec*1000 + t.ru_stime.tv_usec / 1000;
}

#endif /* SUN_BSD */

#if HP_UX

#include <sys/times.h>

long usertime()
{
    struct tms buffer;

    if(times(&buffer) == -1) {
	printf(stderr,"usertime: can't read user time");
	return 0;
    }

    return (long) (buffer.tms_utime / ticks_per_msecond);
}

long systime()
{
    struct tms buffer;

    if(times(&buffer) == -1) {
	printf(stderr,"systime: can't read system time");
	return 0;
    }

    return (buffer.tms_stime / ticks_per_msecond);
}


#endif /* TIMES */

    
