/*    File:	 storage.h  (~bevemyr/KAM/Emulator/storage.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Mar 23 19:57:47 1992
 *    Purpose:   Example storage include file.
 */ 

#define Make_STR(H,To,F) { To = Tag(H,STR); PushOnHeap(H,F); }
#define LoadHVA(H,To)    { To = *H = (TAGGED) H; H++; }
#define CreateHVA(H)     { *H = (TAGGED) H; H++; }

extern code *code_start, *code_end, *code_current;
extern TAGGED *static_start, *static_end, *static_current;
extern TAGGED *heap_start, *heap_end, *heap_current;
extern TAGGED *stack_start, *stack_end, *stack_current;
extern TAGGED *trail_start, *trail_end, *trail_current;

extern long atombase;

extern void init_memory PROTO(());
extern TAGGED *static_alloc PROTO((long));
    
