/*    File:	 inline.c  (~bevemyr/KAM/Emulator/inline.c)
 *    Author:	 Johan Bevemyr
 *    Created:	 Wed Mar 25 10:16:54 1992
 *    Purpose:   C definition of inlinecoded predicates.
 */ 

#include "include.h"

static BOOL prolog_atom PROTO((InArgProto));
static BOOL prolog_var PROTO((InArgProto));

inline_entry inline_table[INLINE_TABLE_SIZE] = {
    {"$atom",		1,	prolog_atom},
    {"$var",		1,	prolog_var}
};

BOOL prolog_atom(InArg)
    InArgDec;
{
    TAGGED X0; 

    Deref(X0,X(regs[0]));

    if(IsCON(X0))
	return TRUE;
    else
	return FALSE;
}

BOOL prolog_var(InArg)
    InArgDec;
{
    TAGGED X0; 

    Deref(X0,X(regs[0]));

    if(IsVAR(X0))
	return TRUE;
    else
	return FALSE;
}

