/*    File:	 engine.h  (~bevemyr/KAM/Emulator/engine.h)
 *    Author:	 Johan Bevemyr
 *    Created:	 Mon Mar 23 19:29:15 1992
 *    Purpose:   Example engine include file
 */ 

#define X(R)             areg[R]         /* for easy access to X-registers */

/**********************************************************************
 *      
 * Choicepoint support 
 *
 */

typedef struct choicepoint {
    TAGGED 		*trail_top;
    TAGGED 		*heap_top;
    struct choicepoint  *last_choice;
    code 		*alternative;
    int 		arity;
    TAGGED 		areg[ANY];
} choicepoint;

#define Make_CP(S,T,Hp,C,P,A)                                                \
{                                                                            \
    register int i, tmp_arity;                                               \
    register choicepoint *newchoice = (choicepoint *) S;                     \
                                                                             \
    tmp_arity = (A);                                                         \
                                                                             \
    S = (TAGGED *) (((long) (S)) + CHOICESIZE + tmp_arity*sizeof(TAGGED));   \
                                                                             \
    newchoice->trail_top = T;                                                \
    newchoice->heap_top = Hp;                                                \
    newchoice->last_choice = C;                                              \
    newchoice->alternative = P;                                              \
    newchoice->arity = tmp_arity;                                            \
                                                                             \
    for(i = 0 ; i < tmp_arity ; i++)                                         \
	newchoice->areg[i] = X(i);                                           \
                                                                             \
    C = newchoice;                                                           \
}

#define CHOICESIZE (sizeof(choicepoint) - sizeof(TAGGED))

/**********************************************************************
 *
 * Deref returns the tagged pointer at the end of the reference chain
 *
 */

#define Deref(Xderefed, X) {                                                 \
    register TAGGED v = (X), vp;                                             \
                                                                             \
    if(IsVAR(v))                                                             \
	do {                                                                 \
	    RefVAR(vp,v);                                                    \
	} while(v != vp && IsVAR(v = vp));                                   \
    Xderefed = v;                                                            \
}
			    
#define PushOnHeap(Hp,Y)  { *Hp = (Y); Hp++;}

#define PushOnTrail(X)    *trail_current++ = (X)

#define Bind(X,Y)         { if(((TAGGED *) X) < heap_uncond) PushOnTrail(X); \
		            *((TAGGED *) X) = Y; }

#define Undo(T)           *((TAGGED *) T) = T

#define UnwindTrail(T)    { register TAGGED *t = (T);                        \
			    while(t != trail_current) {                      \
				trail_current--;                             \
				Undo(*trail_current);                        \
			    }                                                \
			   }
#define Unify(X,Y)         if(unify(X,Y,heap_uncond) == FALSE) goto fail

/**********************************************************************
 *      
 * Prototypes
 *
 */

extern BOOL unify PROTO((TAGGED,TAGGED,TAGGED *));
