% -*- Prolog -*- 
%    File:	expand_term.pl  (~bevemyr/Luther2/Library/expand_term.pl)
%    Author:	Johan Bevemyr
%    Created:	Wed Dec 11 11:33:11 1991
%    Purpose:   Inspired by R, O'Keefe and Tricia.
 
% :- public expand_term/2, phrase/2, phrase/3.

expand_term(Term,Expansion) :-
	var(Term),
	!,
	eq(Term,Expansion).

expand_term(Term,Expansion) :-
	'USERCALL'(current_predicate(_,term_expansion(_,_))),
	'USERCALL'(term_expansion(Term,Mid)),
	!,
	rest_expansion(Mid,Expansion).

expand_term(Term,Expansion) :-
	rest_expansion(Term,Expansion).

%

rest_expansion((Lhs --> Rhs),(Head :- Body2)) :-
	!, nonvar(Lhs), nonvar(Rhs),
	dcg_expansion(Lhs,Rhs,Head,Body1),
	expand_term_body(Body1,Body2).

rest_expansion((Head :- Body1),(Head :- Body2)) :-
	!, expand_term_body(Body1,Body2).

rest_expansion(Term,Term).

%

% Expand DCG rules.

dcg_expansion(Lhs,Rhs,Head,Body) :-
	dcg_left(Lhs,Head,S0,S),
	dcg(Rhs,Body,S0,S).
	
%

dcg_left((H,L),H1,S0,S) :-
	!, list_toplevel(L),
	dlist(L,S1,S),
	dcg_atom(H,H1,S0,S1).

dcg_left(H,H1,S0,S) :-
	dcg_atom(H,H1,S0,S).

%

dcg(X,Z,S0,S) :-
	var(X),
	!, eq(X,Z), eq(S0,S).

dcg((X,Y),Z,S0,S) :-
	!, eq(Z,(X1,Y1)),
	dcg(X,X1,S0,S1),
	dcg(Y,Y1,S1,S).

dcg((X;Y),Z,S0,S) :-
	!, eq(Z,(S1=S,X1;S2=S,Y1)),
	dcg(X,X1,S0,S1),
	dcg(Y,Y1,S0,S2).

dcg((X->Y),Z,S0,S) :-
	!, eq(Z,(X1->Y1)),
	dcg(X,X1,S0,S1),
	dcg(Y,Y1,S1,S).

dcg([],Z,S0,S) :-
	!, eq(Z,(S0=S)).

dcg([X|Y],Z,S0,S) :-
	!, eq(Z,(S0=Out)),
	list_toplevel(Y),
	dlist([X|Y],Out,S).

dcg(!,Z,S0,S) :-
	!, eq(Z,'!'), eq(S0,S).

dcg('!!',Z,S0,S) :-
	!, eq(Z,'!!'), eq(S0,S).

dcg({G},Z,S0,S) :-
	!, eq(Z,G), eq(S0,S).

dcg(G,G1,S0,S) :-
	dcg_atom(G,G1,S0,S).

%

dcg_atom(X,X1,S0,S) :-
	functor(X,F,A),
	A1 is A+1,
	A2 is A+2,
	functor(X1,F,A2),
	arg(A1,X1,S0),
	arg(A2,X1,S),
	copy_args(X,X1,0).

%

dlist([]) --> [].
dlist([X|Y]) --> [X], dlist(Y).

%

copy_args(F1,F2,I) :-
	I1 is I+1,
	arg(I1,F1,X),
	arg(I1,F2,X),
	!, copy_args(F1,F2,I1).

copy_args(_,_,_).

%

list_toplevel(X) :-
	nonvar(X),
	(    eq(X,[])
	;    eq(X,[_|Y]),
	     list_toplevel(Y)
	).

%

'C'([X|S],X,S).

%

phrase(M, List, L):-
	dcg_atom(M, N, L1, L),
	eq(L1, List),
	call(N).

phrase(M, List):-
	phrase(M, List, []).


%

expand_term_body(Var,call(Var)) :-
	var(Var), !.

expand_term_body((G1,Gs1),(G2,Gs2)) :-
	!, expand_term_body(G1,G2),
	expand_term_body(Gs1,Gs2).

expand_term_body((G1;Gs1),(G2;Gs2)) :-
	!, expand_term_body(G1,G2),
	expand_term_body(Gs1,Gs2).

expand_term_body((G1->Gs1),(G2->Gs2)) :-
	!, expand_term_body(G1,G2),
	expand_term_body(Gs1,Gs2).

expand_term_body((\+ Gs1),(\+ Gs2)) :-
	!, expand_term_body(Gs1,Gs2).

expand_term_body(Goal,Goal).

%
